/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import io.netty.handler.ssl.SslContext;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslContextFactory;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslContextFactoryProvider;
import org.opendaylight.netconf.client.mdsal.impl.FilteredSslContext;

final class FilteredSslContextFactory
extends DefaultSslContextFactory {
    private final Set<String> excludedVersions;

    FilteredSslContextFactory(DefaultSslContextFactoryProvider keyStoreProvider, Set<String> excludedVersions) {
        super(keyStoreProvider);
        this.excludedVersions = Objects.requireNonNull(excludedVersions);
    }

    @Override
    SslContext wrapSslContext(SslContext sslContext) {
        return new FilteredSslContext(sslContext, this.excludedVersions);
    }
}

