/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.GetSchema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.get.schema.output.Data;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DOMSourceAnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.spi.source.StringYangTextSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

final class MonitoringSchemaSourceProvider
implements SchemaSourceProvider<YangTextSource> {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringSchemaSourceProvider.class);
    private static final YangInstanceIdentifier.NodeIdentifier FORMAT_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)GetSchema.QNAME, (String)"format").intern());
    private static final YangInstanceIdentifier.NodeIdentifier GET_SCHEMA_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)GetSchema.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier IDENTIFIER_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)GetSchema.QNAME, (String)"identifier").intern());
    private static final YangInstanceIdentifier.NodeIdentifier VERSION_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)GetSchema.QNAME, (String)"version").intern());
    private static final LeafNode<?> FORMAT_LEAF = ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)FORMAT_PATHARG, (Object)Yang.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_DATA_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)Data.QNAME);
    private final NetconfRpcService rpc;
    private final RemoteDeviceId id;

    MonitoringSchemaSourceProvider(RemoteDeviceId id, NetconfRpcService rpc) {
        this.id = Objects.requireNonNull(id);
        this.rpc = Objects.requireNonNull(rpc);
    }

    public ListenableFuture<YangTextSource> getSource(SourceIdentifier sourceIdentifier) {
        String moduleName = sourceIdentifier.name().getLocalName();
        Revision revision = sourceIdentifier.revision();
        ContainerNode getSchemaRequest = MonitoringSchemaSourceProvider.createGetSchemaRequest(moduleName, revision);
        LOG.trace("{}: Loading YANG schema source for {}:{}", new Object[]{this.id, moduleName, revision});
        return Futures.transform(this.rpc.invokeNetconf(GetSchema.QNAME, getSchemaRequest), result -> {
            if (result.errors().isEmpty()) {
                String schemaString = MonitoringSchemaSourceProvider.getSchemaFromRpc(this.id, result.value()).orElseThrow(() -> new IllegalStateException(String.valueOf(this.id) + ": Unexpected response to get-schema, schema not present in message for: " + String.valueOf(sourceIdentifier)));
                LOG.debug("{}: YANG Schema successfully retrieved for {}:{}", new Object[]{this.id, moduleName, revision});
                return new StringYangTextSource(sourceIdentifier, schemaString);
            }
            LOG.warn("{}: YANG schema was not successfully retrieved for {}. Errors: {}", new Object[]{this.id, sourceIdentifier, result.errors()});
            throw new IllegalStateException(String.format("%s: YANG schema was not successfully retrieved for %s. Errors: %s", this.id, sourceIdentifier, result.errors()));
        }, (Executor)MoreExecutors.directExecutor());
    }

    static @NonNull ContainerNode createGetSchemaRequest(String moduleName, @Nullable Revision revision) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)GET_SCHEMA_PATHARG).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)IDENTIFIER_PATHARG, (Object)moduleName)).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)VERSION_PATHARG, (Object)(revision == null ? "" : revision.toString()))).withChild(FORMAT_LEAF).build();
    }

    private static Optional<String> getSchemaFromRpc(RemoteDeviceId id, ContainerNode result) {
        if (result == null) {
            return Optional.empty();
        }
        DataContainerChild child = (DataContainerChild)result.childByArg((YangInstanceIdentifier.PathArgument)NETCONF_DATA_PATHARG);
        Preconditions.checkState((boolean)(child instanceof DOMSourceAnyxmlNode), (String)"%s Unexpected response to get-schema, expected response with one child %s, but was %s", (Object)id, (Object)Data.QNAME, (Object)result);
        DOMSource wrappedNode = ((DOMSourceAnyxmlNode)child).body();
        Element dataNode = (Element)Objects.requireNonNull(wrappedNode.getNode());
        return Optional.of(dataNode.getTextContent().trim());
    }
}

