/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.impl.FieldsFilter;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcStructureTransformer;
import org.opendaylight.netconf.client.mdsal.impl.RpcStructureTransformer;
import org.opendaylight.netconf.client.mdsal.impl.SchemalessRpcStructureTransformer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Commit;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.CopyConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.DiscardChanges;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Get;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.GetConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Lock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Unlock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Validate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.copy.config.input.target.ConfigTarget;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input.source.ConfigSource;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

public final class NetconfBaseOps {
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG_SOURCE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)ConfigSource.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG_TARGET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)ConfigTarget.QNAME);
    private static final LeafNode<String> NETCONF_ERROR_OPTION_ROLLBACK = ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)NetconfMessageTransformUtil.NETCONF_ERROR_OPTION_NODEID, (Object)"rollback-on-error");
    private final NetconfRpcService rpc;
    private final MountPointContext mountContext;
    private final RpcStructureTransformer transformer;

    public NetconfBaseOps(RemoteDeviceServices.Rpcs rpc, MountPointContext mountContext) {
        this.rpc = Objects.requireNonNull(rpc);
        this.mountContext = Objects.requireNonNull(mountContext);
        if (rpc instanceof RemoteDeviceServices.Rpcs.Schemaless) {
            this.transformer = new SchemalessRpcStructureTransformer();
        } else if (rpc instanceof RemoteDeviceServices.Rpcs.Normalized) {
            this.transformer = new NetconfRpcStructureTransformer(mountContext);
        } else {
            throw new IllegalStateException("Unhandled rpcs " + String.valueOf(rpc));
        }
    }

    public ListenableFuture<? extends DOMRpcResult> lock(FutureCallback<DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier datastore) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Lock.QNAME, NetconfBaseOps.getLockContent(datastore)));
    }

    private static <T> ListenableFuture<T> addCallback(FutureCallback<? super T> callback, ListenableFuture<T> future) {
        Futures.addCallback(future, callback, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    public ListenableFuture<? extends DOMRpcResult> lockCandidate(FutureCallback<DOMRpcResult> callback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Lock.QNAME, NetconfBaseOps.getLockContent(NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID)));
    }

    public ListenableFuture<? extends DOMRpcResult> lockRunning(FutureCallback<DOMRpcResult> callback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Lock.QNAME, NetconfBaseOps.getLockContent(NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID)));
    }

    public ListenableFuture<? extends DOMRpcResult> unlock(FutureCallback<DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier datastore) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Unlock.QNAME, NetconfBaseOps.getUnLockContent(datastore)));
    }

    public ListenableFuture<? extends DOMRpcResult> unlockRunning(FutureCallback<DOMRpcResult> callback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Unlock.QNAME, NetconfBaseOps.getUnLockContent(NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID)));
    }

    public ListenableFuture<? extends DOMRpcResult> unlockCandidate(FutureCallback<DOMRpcResult> callback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Unlock.QNAME, NetconfBaseOps.getUnLockContent(NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID)));
    }

    public ListenableFuture<? extends DOMRpcResult> discardChanges(FutureCallback<DOMRpcResult> callback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(DiscardChanges.QNAME, NetconfMessageTransformUtil.DISCARD_CHANGES_RPC_CONTENT));
    }

    public ListenableFuture<? extends DOMRpcResult> commit(FutureCallback<DOMRpcResult> callback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Commit.QNAME, NetconfMessageTransformUtil.COMMIT_RPC_CONTENT));
    }

    public ListenableFuture<? extends DOMRpcResult> validate(FutureCallback<DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier datastore) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Validate.QNAME, NetconfBaseOps.getValidateContent(Objects.requireNonNull(datastore))));
    }

    public ListenableFuture<? extends DOMRpcResult> validateCandidate(FutureCallback<DOMRpcResult> callback) {
        return this.validate(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID);
    }

    public ListenableFuture<? extends DOMRpcResult> validateRunning(FutureCallback<DOMRpcResult> callback) {
        return this.validate(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID);
    }

    public ListenableFuture<? extends DOMRpcResult> copyConfig(FutureCallback<DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier sourceDatastore, YangInstanceIdentifier.NodeIdentifier targetDatastore) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(CopyConfig.QNAME, NetconfBaseOps.getCopyConfigContent(sourceDatastore, targetDatastore)));
    }

    public ListenableFuture<? extends DOMRpcResult> copyRunningToCandidate(FutureCallback<DOMRpcResult> callback) {
        return this.copyConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID, NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID);
    }

    public ListenableFuture<? extends DOMRpcResult> getConfig(FutureCallback<DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier datastore, Optional<YangInstanceIdentifier> filterPath) {
        ContainerNode source = NetconfBaseOps.getSourceNode(datastore);
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(GetConfig.QNAME, NetconfBaseOps.nonEmptyFilter(filterPath).map(path -> NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, new DataContainerChild[]{source, this.transformer.toFilterStructure((YangInstanceIdentifier)path)})).orElseGet(() -> NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, new DataContainerChild[]{source}))));
    }

    private ListenableFuture<? extends DOMRpcResult> getConfig(FutureCallback<DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier datastore, Optional<YangInstanceIdentifier> filterPath, List<YangInstanceIdentifier> fields) {
        ContainerNode rpcInput = NetconfBaseOps.nonEmptyFilter(filterPath).isPresent() ? NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, new DataContainerChild[]{NetconfBaseOps.getSourceNode(datastore), this.transformer.toFilterStructure(List.of(FieldsFilter.of(filterPath.orElseThrow(), fields)))}) : (NetconfBaseOps.containsEmptyPath(fields) ? NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, new DataContainerChild[]{NetconfBaseOps.getSourceNode(datastore)}) : NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, new DataContainerChild[]{NetconfBaseOps.getSourceNode(datastore), this.getSubtreeFilterFromRootFields(fields)}));
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(GetConfig.QNAME, rpcInput));
    }

    public ListenableFuture<Optional<NormalizedNode>> getConfigRunningData(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return this.extractData(filterPath, this.getConfigRunning(callback, filterPath));
    }

    public ListenableFuture<Optional<NormalizedNode>> getConfigRunningData(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath, List<YangInstanceIdentifier> fields) {
        if (fields.isEmpty()) {
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Failed to build NETCONF GET-CONFIG RPC: provided list of fields is empty; filter path: " + String.valueOf(filterPath)));
        }
        return this.extractData(filterPath, this.getConfigRunning(callback, filterPath, fields));
    }

    public ListenableFuture<Optional<NormalizedNode>> getData(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return this.extractData(filterPath, this.get(callback, filterPath));
    }

    public ListenableFuture<Optional<NormalizedNode>> getData(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath, List<YangInstanceIdentifier> fields) {
        if (fields.isEmpty()) {
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Failed to build NETCONF GET RPC: provided list of fields is empty; filter path: " + String.valueOf(filterPath)));
        }
        return this.extractData(filterPath, this.get(callback, filterPath, fields));
    }

    private ListenableFuture<Optional<NormalizedNode>> extractData(Optional<YangInstanceIdentifier> path, ListenableFuture<? extends DOMRpcResult> configRunning) {
        return Futures.transform(configRunning, result -> {
            Collection errors = result.errors();
            Preconditions.checkArgument((boolean)errors.isEmpty(), (String)"Unable to read data: %s, errors: %s", (Object)path, (Object)errors);
            return this.transformer.selectFromDataStructure((DataContainerChild)result.value().getChildByArg((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID), (YangInstanceIdentifier)path.orElseThrow());
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<? extends DOMRpcResult> getConfigRunning(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return this.getConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID, filterPath);
    }

    private ListenableFuture<? extends DOMRpcResult> getConfigRunning(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath, List<YangInstanceIdentifier> fields) {
        return this.getConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID, filterPath, fields);
    }

    public ListenableFuture<? extends DOMRpcResult> getConfigCandidate(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return this.getConfig(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID, filterPath);
    }

    public ListenableFuture<? extends DOMRpcResult> get(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Get.QNAME, NetconfBaseOps.nonEmptyFilter(filterPath).map(path -> NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_NODEID, new DataContainerChild[]{NetconfMessageTransformUtil.toFilterStructure(path, this.mountContext.modelContext())})).orElse(NetconfMessageTransformUtil.GET_RPC_CONTENT)));
    }

    private ListenableFuture<? extends DOMRpcResult> get(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath, List<YangInstanceIdentifier> fields) {
        ContainerNode rpcInput = NetconfBaseOps.nonEmptyFilter(filterPath).isPresent() ? NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_NODEID, new DataContainerChild[]{this.transformer.toFilterStructure(List.of(FieldsFilter.of(filterPath.orElseThrow(), fields)))}) : (NetconfBaseOps.containsEmptyPath(fields) ? NetconfMessageTransformUtil.GET_RPC_CONTENT : NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_NODEID, this.getSubtreeFilterFromRootFields(fields)));
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(Get.QNAME, rpcInput));
    }

    private static boolean containsEmptyPath(List<YangInstanceIdentifier> fields) {
        return fields.stream().anyMatch(YangInstanceIdentifier::isEmpty);
    }

    private DataContainerChild getSubtreeFilterFromRootFields(List<YangInstanceIdentifier> fields) {
        return this.transformer.toFilterStructure(fields.stream().map(fieldPath -> Map.entry(YangInstanceIdentifier.of((Iterable)Iterables.limit((Iterable)fieldPath.getPathArguments(), (int)1)), YangInstanceIdentifier.of((Iterable)Iterables.skip((Iterable)fieldPath.getPathArguments(), (int)1)))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toUnmodifiableList()))).entrySet().stream().map(entry -> FieldsFilter.of((YangInstanceIdentifier)entry.getKey(), (List)entry.getValue())).collect(Collectors.toUnmodifiableList()));
    }

    private static Optional<YangInstanceIdentifier> nonEmptyFilter(Optional<YangInstanceIdentifier> filterPath) {
        return filterPath.filter(path -> !path.isEmpty());
    }

    public ListenableFuture<? extends DOMRpcResult> editConfigCandidate(FutureCallback<? super DOMRpcResult> callback, DataContainerChild editStructure, EffectiveOperation modifyAction, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID, editStructure, Optional.of(modifyAction), rollback);
    }

    public ListenableFuture<? extends DOMRpcResult> editConfigCandidate(FutureCallback<? super DOMRpcResult> callback, DataContainerChild editStructure, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_NODEID, editStructure, Optional.empty(), rollback);
    }

    public ListenableFuture<? extends DOMRpcResult> editConfigRunning(FutureCallback<? super DOMRpcResult> callback, DataContainerChild editStructure, EffectiveOperation modifyAction, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID, editStructure, Optional.of(modifyAction), rollback);
    }

    public ListenableFuture<? extends DOMRpcResult> editConfigRunning(FutureCallback<? super DOMRpcResult> callback, DataContainerChild editStructure, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID, editStructure, Optional.empty(), rollback);
    }

    public ListenableFuture<? extends DOMRpcResult> editConfig(FutureCallback<? super DOMRpcResult> callback, YangInstanceIdentifier.NodeIdentifier datastore, DataContainerChild editStructure, Optional<EffectiveOperation> modifyAction, boolean rollback) {
        return NetconfBaseOps.addCallback(Objects.requireNonNull(callback), this.rpc.invokeNetconf(EditConfig.QNAME, NetconfBaseOps.getEditConfigContent(Objects.requireNonNull(datastore), Objects.requireNonNull(editStructure), modifyAction, rollback)));
    }

    public ChoiceNode createEditConfigStructure(Optional<NormalizedNode> lastChild, Optional<EffectiveOperation> operation, YangInstanceIdentifier dataPath) {
        return (ChoiceNode)ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.EDIT_CONTENT_NODEID).withChild(this.transformer.createEditConfigStructure(lastChild, dataPath, operation)).build();
    }

    private static ContainerNode getEditConfigContent(YangInstanceIdentifier.NodeIdentifier datastore, DataContainerChild editStructure, Optional<EffectiveOperation> defaultOperation, boolean rollback) {
        DataContainerNodeBuilder editBuilder = ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_EDIT_CONFIG_NODEID).withChild((DataContainerChild)NetconfBaseOps.getTargetNode(datastore));
        defaultOperation.ifPresent(op -> editBuilder.withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)NetconfMessageTransformUtil.NETCONF_DEFAULT_OPERATION_NODEID, (Object)op.xmlValue())));
        if (rollback) {
            editBuilder.withChild(NETCONF_ERROR_OPTION_ROLLBACK);
        }
        return (ContainerNode)editBuilder.withChild(editStructure).build();
    }

    public static @NonNull ContainerNode getSourceNode(YangInstanceIdentifier.NodeIdentifier datastore) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_SOURCE_NODEID).withChild((DataContainerChild)ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CONFIG_SOURCE_NODEID).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)datastore, (Object)Empty.value())).build()).build();
    }

    public static @NonNull ContainerNode getLockContent(YangInstanceIdentifier.NodeIdentifier datastore) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_LOCK_NODEID).withChild((DataContainerChild)NetconfBaseOps.getTargetNode(datastore)).build();
    }

    public static @NonNull ContainerNode getTargetNode(YangInstanceIdentifier.NodeIdentifier datastore) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_TARGET_NODEID).withChild((DataContainerChild)ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CONFIG_TARGET_NODEID).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)datastore, (Object)Empty.value())).build()).build();
    }

    public static @NonNull ContainerNode getCopyConfigContent(YangInstanceIdentifier.NodeIdentifier sourceDatastore, YangInstanceIdentifier.NodeIdentifier targetDatastore) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_COPY_CONFIG_NODEID).withChild((DataContainerChild)NetconfBaseOps.getTargetNode(targetDatastore)).withChild((DataContainerChild)NetconfBaseOps.getSourceNode(sourceDatastore)).build();
    }

    public static @NonNull ContainerNode getValidateContent(YangInstanceIdentifier.NodeIdentifier sourceDatastore) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_VALIDATE_NODEID).withChild((DataContainerChild)NetconfBaseOps.getSourceNode(sourceDatastore)).build();
    }

    public static @NonNull ContainerNode getUnLockContent(YangInstanceIdentifier.NodeIdentifier datastore) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_UNLOCK_NODEID).withChild((DataContainerChild)NetconfBaseOps.getTargetNode(datastore)).build();
    }
}

