/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.messages.NotificationMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.impl.FieldsFilter;
import org.opendaylight.netconf.client.mdsal.impl.MessageCounter;
import org.opendaylight.netconf.common.mdsal.NormalizedDataUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Candidate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.CommitInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.CopyConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.DiscardChangesInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Get;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.GetConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Lock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Unlock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Validate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.edit.config.input.EditContent;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.output.Data;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.input.Filter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.YangInstanceIdentifierWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedMetadata;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaOrderedNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfMessageTransformUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageTransformUtil.class);
    public static final String MESSAGE_ID_PREFIX = "m";
    private static final Document BLANK_DOCUMENT = XmlUtil.newDocument();
    public static final @NonNull QName IETF_NETCONF_MONITORING = QName.create((QName)NetconfState.QNAME, (String)"ietf-netconf-monitoring").intern();
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_DATA_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)Data.QNAME);
    public static final @NonNull QName NETCONF_RPC_REPLY_QNAME = YangModuleInfoImpl.qnameOf((String)"rpc-reply");
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_RPC_REPLY_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_RPC_REPLY_QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_ERROR_OPTION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"error-option"));
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_RUNNING_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"running"));
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_SOURCE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"source"));
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_CANDIDATE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)Candidate.QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_TARGET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"target"));
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"config"));
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_VALIDATE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)Validate.QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_COPY_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)CopyConfig.QNAME);
    private static final @NonNull QName NETCONF_OPERATION_QNAME_LEGACY = QName.create((String)"urn:ietf:params:xml:ns:netconf:base:1.0", (String)"operation").intern();
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_DEFAULT_OPERATION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"default-operation"));
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_EDIT_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)EditConfig.QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_GET_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)GetConfig.QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_GET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)Get.QNAME);
    public static final @NonNull QName NETCONF_RPC_QNAME = YangModuleInfoImpl.qnameOf((String)"rpc");
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_LOCK_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)Lock.QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier NETCONF_UNLOCK_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)Unlock.QNAME);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier EDIT_CONTENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)EditContent.QNAME);
    public static final @NonNull ContainerNode DISCARD_CHANGES_RPC_CONTENT = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)DiscardChangesInput.QNAME)).build();
    public static final @NonNull ContainerNode COMMIT_RPC_CONTENT = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)CommitInput.QNAME)).build();
    public static final @NonNull ContainerNode GET_RPC_CONTENT = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_GET_NODEID).build();
    public static final @NonNull AnyxmlNode<?> EMPTY_FILTER = NetconfMessageTransformUtil.buildFilterStructure(NetconfMessageTransformUtil.newFilterElement());

    private NetconfMessageTransformUtil() {
    }

    public static AnyxmlNode<?> toFilterStructure(YangInstanceIdentifier identifier, EffectiveModelContext ctx) {
        Element element = NetconfMessageTransformUtil.newFilterElement();
        try {
            NormalizedDataUtil.writeFilter((YangInstanceIdentifier)identifier, (DOMResult)new DOMResult(element), (EffectiveModelContext)ctx, null);
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize filter element for path " + String.valueOf(identifier), e);
        }
        return NetconfMessageTransformUtil.buildFilterStructure(element);
    }

    public static AnyxmlNode<?> toFilterStructure(List<FieldsFilter> fieldsFilters, EffectiveModelContext ctx) {
        Preconditions.checkState((!fieldsFilters.isEmpty() ? 1 : 0) != 0, (Object)"An empty list of subtree filters is not allowed");
        Element element = NetconfMessageTransformUtil.newFilterElement();
        for (FieldsFilter filter : fieldsFilters) {
            try {
                NormalizedDataUtil.writeFilter((YangInstanceIdentifier)filter.path(), (DOMResult)new DOMResult(element), (EffectiveModelContext)ctx, null, filter.fields());
            }
            catch (IOException | XMLStreamException e) {
                throw new IllegalStateException(String.format("Unable to serialize filter element for path %s with fields: %s", filter.path(), filter.fields()), e);
            }
        }
        return NetconfMessageTransformUtil.buildFilterStructure(element);
    }

    private static Element newFilterElement() {
        Element element = BLANK_DOCUMENT.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "filter");
        element.setAttribute("type", "subtree");
        return element;
    }

    private static AnyxmlNode<?> buildFilterStructure(Element element) {
        return (AnyxmlNode)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Filter.QNAME)).withValue((Object)new DOMSource(element)).build();
    }

    public static YangInstanceIdentifier.NodeIdentifier toId(YangInstanceIdentifier.PathArgument arg) {
        YangInstanceIdentifier.NodeIdentifier nodeId;
        return arg instanceof YangInstanceIdentifier.NodeIdentifier ? (nodeId = (YangInstanceIdentifier.NodeIdentifier)arg) : NetconfMessageTransformUtil.toId(arg.getNodeType());
    }

    public static YangInstanceIdentifier.NodeIdentifier toId(QName nodeType) {
        return new YangInstanceIdentifier.NodeIdentifier(nodeType);
    }

    public static Element getDataSubtree(Document doc) {
        return (Element)doc.getElementsByTagNameNS("urn:ietf:params:xml:ns:netconf:base:1.0", "data").item(0);
    }

    public static boolean isDataRetrievalOperation(QName rpc) {
        return YangConstants.NETCONF_NAMESPACE.equals((Object)rpc.getNamespace()) && (GetConfig.QNAME.getLocalName().equals(rpc.getLocalName()) || Get.QNAME.getLocalName().equals(rpc.getLocalName()));
    }

    @Deprecated
    public static @NonNull ContainerNode wrap(QName name, DataContainerChild ... node) {
        return NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.toId(name), node);
    }

    public static @NonNull ContainerNode wrap(YangInstanceIdentifier.NodeIdentifier name, DataContainerChild ... node) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).withValue((Collection)ImmutableList.copyOf((Object[])node)).build();
    }

    public static AnyxmlNode<DOMSource> createEditConfigAnyxml(EffectiveModelContext ctx, YangInstanceIdentifier dataPath, Optional<EffectiveOperation> operation, Optional<NormalizedNode> lastChildOverride) {
        Element element;
        block23: {
            if (dataPath.isEmpty()) {
                NormalizedNode override = lastChildOverride.orElseThrow(() -> new IllegalArgumentException("Data has to be present when creating structure for top level element"));
                Preconditions.checkArgument((boolean)(override instanceof DataContainerChild), (String)"Data has to be either container or a list node when creating structure for top level element, but was: %s", (Object)override);
            }
            element = BLANK_DOCUMENT.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "config");
            NormalizedMetadata metadata = operation.map(o -> NetconfMessageTransformUtil.leafMetadata(dataPath, o)).orElse(null);
            try {
                if (lastChildOverride.isPresent()) {
                    YangInstanceIdentifier parentPath = dataPath.isEmpty() ? dataPath : dataPath.coerceParent();
                    NormalizationResultHolder result = new NormalizationResultHolder();
                    try (NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
                         YangInstanceIdentifierWriter iidWriter = YangInstanceIdentifierWriter.open((NormalizedNodeStreamWriter)streamWriter, (DataNodeContainer)ctx, (YangInstanceIdentifier)parentPath);
                         NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);){
                        nnWriter.write(lastChildOverride.orElseThrow());
                    }
                    NormalizedDataUtil.writeNormalizedNode((NormalizedNode)result.getResult().data(), (NormalizedMetadata)metadata, (DOMResult)new DOMResult(element), (EffectiveModelContext)ctx, null);
                    break block23;
                }
                NormalizedDataUtil.writeNormalizedNode((YangInstanceIdentifier)dataPath, (NormalizedMetadata)metadata, (DOMResult)new DOMResult(element), (EffectiveModelContext)ctx, null);
            }
            catch (IOException | XMLStreamException e) {
                throw new IllegalStateException("Unable to serialize edit config content element for path " + String.valueOf(dataPath), e);
            }
        }
        return (AnyxmlNode)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_CONFIG_NODEID).withValue((Object)new DOMSource(element)).build();
    }

    private static NormalizedMetadata leafMetadata(YangInstanceIdentifier path, EffectiveOperation oper) {
        ImmutableNormalizedMetadata currentMeta;
        List args = path.getPathArguments();
        record BuilderAndArg(ImmutableNormalizedMetadata.Builder builder, YangInstanceIdentifier.PathArgument arg) {
            BuilderAndArg {
                Objects.requireNonNull(builder);
                Objects.requireNonNull(arg);
            }
        }
        ArrayDeque<BuilderAndArg> builders = new ArrayDeque<BuilderAndArg>(args.size());
        for (YangInstanceIdentifier.PathArgument arg : args) {
            builders.push(new BuilderAndArg(ImmutableNormalizedMetadata.builder(), arg));
        }
        ((BuilderAndArg)builders.peek()).builder.withAnnotation(NETCONF_OPERATION_QNAME_LEGACY, (Object)oper.xmlValue());
        while (true) {
            BuilderAndArg current = (BuilderAndArg)builders.pop();
            currentMeta = current.builder.build();
            BuilderAndArg parent = (BuilderAndArg)builders.peek();
            if (parent == null) break;
            parent.builder.withChild(current.arg, currentMeta);
        }
        return currentMeta;
    }

    public static DataContainerChild createEditConfigStructure(EffectiveModelContext ctx, YangInstanceIdentifier dataPath, Optional<EffectiveOperation> operation, Optional<NormalizedNode> lastChildOverride) {
        return (DataContainerChild)ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)EDIT_CONTENT_NODEID).withChild(NetconfMessageTransformUtil.createEditConfigAnyxml(ctx, dataPath, operation, lastChildOverride)).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute toPath(QName rpc) {
        return SchemaNodeIdentifier.Absolute.of((QName)rpc);
    }

    public static Map.Entry<Instant, XmlElement> stripNotification(NetconfMessage message) {
        XmlElement notificationElement;
        XmlElement eventTimeElement;
        XmlElement xmlElement = XmlElement.fromDomDocument((Document)message.getDocument());
        List childElements = xmlElement.getChildElements();
        Preconditions.checkArgument((childElements.size() == 2 ? 1 : 0) != 0, (String)"Unable to parse notification %s, unexpected format.\nExpected 2 childElements, actual childElements size is %s", (Object)message, (int)childElements.size());
        if (((XmlElement)childElements.get(0)).getName().equals("eventTime")) {
            eventTimeElement = (XmlElement)childElements.get(0);
            notificationElement = (XmlElement)childElements.get(1);
        } else if (((XmlElement)childElements.get(1)).getName().equals("eventTime")) {
            eventTimeElement = (XmlElement)childElements.get(1);
            notificationElement = (XmlElement)childElements.get(0);
        } else {
            throw new IllegalArgumentException("Notification payload does not contain eventTime " + String.valueOf(message));
        }
        try {
            return Map.entry((Instant)NotificationMessage.RFC3339_DATE_PARSER.apply(eventTimeElement.getTextContent()), notificationElement);
        }
        catch (DocumentedException e) {
            throw new IllegalArgumentException("Notification payload does not contain eventTime " + String.valueOf(message), e);
        }
        catch (DateTimeParseException e) {
            LOG.warn("Unable to parse event time from {}. Setting time to {}", new Object[]{eventTimeElement, NotificationMessage.UNKNOWN_EVENT_TIME, e});
            return Map.entry(NotificationMessage.UNKNOWN_EVENT_TIME, notificationElement);
        }
    }

    public static DOMResult prepareDomResultForRpcRequest(QName rpcQName, MessageCounter counter) {
        Document document = XmlUtil.newDocument();
        Element rpcNS = document.createElementNS(NETCONF_RPC_QNAME.getNamespace().toString(), NETCONF_RPC_QNAME.getLocalName());
        rpcNS.setAttribute("message-id", counter.getNewMessageId(MESSAGE_ID_PREFIX));
        Element elementNS = document.createElementNS(rpcQName.getNamespace().toString(), rpcQName.getLocalName());
        rpcNS.appendChild(elementNS);
        document.appendChild(rpcNS);
        return new DOMResult(elementNS);
    }

    public static DOMResult prepareDomResultForActionRequest(DataSchemaContextTree dataSchemaContextTree, DOMDataTreeIdentifier domDataTreeIdentifier, MessageCounter counter, QName action) {
        Document document = XmlUtil.newDocument();
        Element rpcNS = document.createElementNS(NETCONF_RPC_QNAME.getNamespace().toString(), NETCONF_RPC_QNAME.getLocalName());
        rpcNS.setAttribute("message-id", counter.getNewMessageId(MESSAGE_ID_PREFIX));
        Element actionNS = document.createElementNS("urn:ietf:params:xml:ns:yang:1", "action");
        DataSchemaContext.Composite rootSchemaContextNode = dataSchemaContextTree.getRoot();
        Element actionData = NetconfMessageTransformUtil.prepareActionData((DataSchemaContext)rootSchemaContextNode, actionNS, domDataTreeIdentifier.path().getPathArguments().iterator(), document);
        Element specificActionElement = document.createElementNS(action.getNamespace().toString(), action.getLocalName());
        actionData.appendChild(specificActionElement);
        rpcNS.appendChild(actionNS);
        document.appendChild(rpcNS);
        return new DOMResult(specificActionElement);
    }

    private static Element prepareActionData(DataSchemaContext currentParentSchemaNode, Element actionNS, Iterator<YangInstanceIdentifier.PathArgument> iterator, Document document) {
        if (iterator.hasNext()) {
            DataSchemaContext dataSchemaContext;
            YangInstanceIdentifier.PathArgument next = iterator.next();
            if (currentParentSchemaNode instanceof DataSchemaContext.Composite) {
                DataSchemaContext.Composite composite = (DataSchemaContext.Composite)currentParentSchemaNode;
                dataSchemaContext = composite.childByArg(next);
            } else {
                dataSchemaContext = null;
            }
            DataSchemaContext current = dataSchemaContext;
            Preconditions.checkArgument((current != null ? 1 : 0) != 0, (String)"Invalid input: schema for argument %s not found", (Object)next);
            if (current instanceof DataSchemaContext.PathMixin) {
                return NetconfMessageTransformUtil.prepareActionData(current, actionNS, iterator, document);
            }
            QName actualNS = next.getNodeType();
            Element actualElement = document.createElementNS(actualNS.getNamespace().toString(), actualNS.getLocalName());
            if (next instanceof YangInstanceIdentifier.NodeWithValue) {
                actualElement.setNodeValue(((YangInstanceIdentifier.NodeWithValue)next).getValue().toString());
            } else if (next instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                for (Map.Entry entry : ((YangInstanceIdentifier.NodeIdentifierWithPredicates)next).entrySet()) {
                    Element entryElement = document.createElementNS(((QName)entry.getKey()).getNamespace().toString(), ((QName)entry.getKey()).getLocalName());
                    entryElement.setTextContent(entry.getValue().toString());
                    entryElement.setNodeValue(entry.getValue().toString());
                    actualElement.appendChild(entryElement);
                }
            }
            actionNS.appendChild(actualElement);
            return NetconfMessageTransformUtil.prepareActionData(current, actualElement, iterator, document);
        }
        return actionNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedOperationInput(ContainerNode normalized, DOMResult result, SchemaNodeIdentifier.Absolute operationPath, EffectiveModelContext baseNetconfCtx) throws IOException, XMLStreamException {
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)baseNetconfCtx, (SchemaNodeIdentifier.Absolute)operationPath);
        stack.enterSchemaTree(YangConstants.operationInputQName((QNameModule)operationPath.lastNodeIdentifier().getModule()));
        SchemaTreeInference inputInference = stack.toSchemaTreeInference();
        XMLStreamWriter writer = NormalizedDataUtil.XML_FACTORY.createXMLStreamWriter(result);
        try (NormalizedNodeStreamWriter normalizedNodeStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)writer, (EffectiveStatementInference)inputInference);
             SchemaOrderedNormalizedNodeWriter normalizedNodeWriter = new SchemaOrderedNormalizedNodeWriter(normalizedNodeStreamWriter, inputInference);){
            Collection value = normalized.body();
            normalizedNodeWriter.write(value);
            normalizedNodeWriter.flush();
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                LOG.warn("Unable to close resource properly", (Throwable)e);
            }
        }
    }
}

