/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.client.mdsal.api.ActionTransformer;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.NotificationTransformer;
import org.opendaylight.netconf.client.mdsal.api.RpcTransformer;
import org.opendaylight.netconf.client.mdsal.impl.MessageCounter;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.GetConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscription;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetconfMessageTransformer
implements ActionTransformer,
NotificationTransformer,
RpcTransformer<ContainerNode, DOMRpcResult> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageTransformer.class);
    private static final ImmutableSet<XMLNamespace> BASE_OR_NOTIFICATION_NS = ImmutableSet.of((Object)GetConfig.QNAME.getNamespace(), (Object)NetconfCapabilityChange.QNAME.getNamespace(), (Object)CreateSubscription.QNAME.getNamespace());
    private final MountPointContext mountContext;
    private final DataSchemaContextTree contextTree;
    private final BaseNetconfSchema baseSchema;
    private final MessageCounter counter = new MessageCounter();
    private final ImmutableMap<QName, ? extends RpcDefinition> mappedRpcs;
    private final Multimap<QName, ? extends NotificationDefinition> mappedNotifications;
    private final boolean strictParsing;
    private final ImmutableMap<SchemaNodeIdentifier.Absolute, ActionDefinition> actions;

    public NetconfMessageTransformer(MountPointContext mountContext, boolean strictParsing, BaseNetconfSchema baseSchema) {
        this.mountContext = Objects.requireNonNull(mountContext);
        EffectiveModelContext modelContext = mountContext.modelContext();
        this.contextTree = DataSchemaContextTree.from((EffectiveModelContext)modelContext);
        this.mappedRpcs = Maps.uniqueIndex((Iterable)modelContext.getOperations(), SchemaNode::getQName);
        this.actions = NetconfMessageTransformer.getActions(modelContext);
        this.mappedNotifications = Multimaps.index((Iterable)modelContext.getNotifications(), node -> node.getQName().withoutRevision());
        this.baseSchema = baseSchema;
        this.strictParsing = strictParsing;
    }

    @VisibleForTesting
    static ImmutableMap<SchemaNodeIdentifier.Absolute, ActionDefinition> getActions(EffectiveModelContext schemaContext) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        NetconfMessageTransformer.findAction((DataSchemaNode)schemaContext, new ArrayDeque<QName>(), (ImmutableMap.Builder<SchemaNodeIdentifier.Absolute, ActionDefinition>)builder);
        return builder.build();
    }

    private static void findAction(DataSchemaNode dataSchemaNode, Deque<QName> path, ImmutableMap.Builder<SchemaNodeIdentifier.Absolute, ActionDefinition> builder) {
        block5: {
            block4: {
                if (dataSchemaNode instanceof ActionNodeContainer) {
                    for (ActionDefinition actionDefinition : ((ActionNodeContainer)dataSchemaNode).getActions()) {
                        path.addLast(actionDefinition.getQName());
                        builder.put((Object)SchemaNodeIdentifier.Absolute.of(path), (Object)actionDefinition);
                        path.removeLast();
                    }
                }
                if (!(dataSchemaNode instanceof DataNodeContainer)) break block4;
                for (DataSchemaNode innerDataSchemaNode : ((DataNodeContainer)dataSchemaNode).getChildNodes()) {
                    path.addLast(innerDataSchemaNode.getQName());
                    NetconfMessageTransformer.findAction(innerDataSchemaNode, path, builder);
                    path.removeLast();
                }
                break block5;
            }
            if (!(dataSchemaNode instanceof ChoiceSchemaNode)) break block5;
            for (CaseSchemaNode caze : ((ChoiceSchemaNode)dataSchemaNode).getCases()) {
                path.addLast(caze.getQName());
                NetconfMessageTransformer.findAction((DataSchemaNode)caze, path, builder);
                path.removeLast();
            }
        }
    }

    @Override
    public synchronized DOMNotification toNotification(NetconfMessage message) {
        QName notificationNoRev;
        Map.Entry<Instant, XmlElement> stripped = NetconfMessageTransformUtil.stripNotification(message);
        try {
            notificationNoRev = QName.create((String)stripped.getValue().getNamespace(), (String)stripped.getValue().getName()).withoutRevision();
        }
        catch (MissingNameSpaceException e) {
            throw new IllegalArgumentException("Unable to parse notification " + String.valueOf(message) + ", cannot find namespace", e);
        }
        Collection matchingTopLevel = this.mappedNotifications.get((Object)notificationNoRev);
        Element element = stripped.getValue().getDomElement();
        if (!matchingTopLevel.isEmpty()) {
            NotificationDefinition notification = NetconfMessageTransformer.getMostRecentNotification(matchingTopLevel);
            return new NetconfDeviceNotification(this.toNotification(SchemaNodeIdentifier.Absolute.of((QName)notification.getQName()), element), stripped.getKey());
        }
        NestedNotificationInfo nestedInfo = this.findNestedNotification(message, element).orElseThrow(() -> new IllegalArgumentException("Unable to parse notification for " + String.valueOf(element) + ". Available notifications: " + String.valueOf(this.mappedNotifications.keySet())));
        SchemaNodeIdentifier.Absolute schemaPath = nestedInfo.schemaPath;
        return new NetconfDeviceTreeNotification(this.toNotification(schemaPath, nestedInfo.element), schemaPath, stripped.getKey(), nestedInfo.instancePath);
    }

    private @GuardedBy(value={"this"}) ContainerNode toNotification(SchemaNodeIdentifier.Absolute notificationPath, Element element) {
        NormalizationResultHolder resultHolder = new NormalizationResultHolder();
        try {
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (MountPointContext)this.mountContext, (EffectiveStatementInference)SchemaInferenceStack.of((EffectiveModelContext)this.mountContext.modelContext(), (SchemaNodeIdentifier.Absolute)notificationPath).toInference(), (boolean)this.strictParsing);
            xmlParser.traverse(new DOMSource(element));
        }
        catch (IOException | UnsupportedOperationException | XMLStreamException e) {
            throw new IllegalArgumentException(String.format("Failed to parse notification %s", element), e);
        }
        return (ContainerNode)resultHolder.getResult().data();
    }

    private Optional<NestedNotificationInfo> findNestedNotification(NetconfMessage message, Element element) {
        Iterator modules = this.mountContext.modelContext().findModules(XMLNamespace.of((String)element.getNamespaceURI())).iterator();
        if (!modules.hasNext()) {
            throw new IllegalArgumentException("Unable to parse notification " + String.valueOf(message) + ", cannot find top level module");
        }
        Module module = (Module)modules.next();
        QName topLevelNodeQName = QName.create((String)element.getNamespaceURI(), (String)element.getLocalName());
        for (DataSchemaNode childNode : module.getChildNodes()) {
            if (!topLevelNodeQName.isEqualWithoutRevision(childNode.getQName())) continue;
            return Optional.of(this.traverseXmlNodeContainingNotification(element, (SchemaNode)childNode, new ArrayList<QName>(), YangInstanceIdentifier.builder()));
        }
        return Optional.empty();
    }

    private NestedNotificationInfo traverseXmlNodeContainingNotification(Node xmlNode, SchemaNode schemaNode, List<QName> schemaBuilder, YangInstanceIdentifier.InstanceIdentifierBuilder instanceBuilder) {
        if (schemaNode instanceof ContainerSchemaNode) {
            ContainerSchemaNode containerSchema = (ContainerSchemaNode)schemaNode;
            instanceBuilder.node(QName.create((String)xmlNode.getNamespaceURI(), (String)xmlNode.getLocalName()));
            schemaBuilder.add(containerSchema.getQName());
            Map.Entry<Node, SchemaNode> xmlContainerChildPair = NetconfMessageTransformer.findXmlContainerChildPair(xmlNode, containerSchema);
            return this.traverseXmlNodeContainingNotification(xmlContainerChildPair.getKey(), xmlContainerChildPair.getValue(), schemaBuilder, instanceBuilder);
        }
        if (schemaNode instanceof ListSchemaNode) {
            ListSchemaNode listSchema = (ListSchemaNode)schemaNode;
            instanceBuilder.node(QName.create((String)xmlNode.getNamespaceURI(), (String)xmlNode.getLocalName()));
            schemaBuilder.add(listSchema.getQName());
            Map<QName, Object> listKeys = NetconfMessageTransformer.findXmlListKeys(xmlNode, listSchema);
            instanceBuilder.nodeWithKey(QName.create((String)xmlNode.getNamespaceURI(), (String)xmlNode.getLocalName()), listKeys);
            Map.Entry<Node, SchemaNode> xmlListChildPair = NetconfMessageTransformer.findXmlListChildPair(xmlNode, listSchema);
            return this.traverseXmlNodeContainingNotification(xmlListChildPair.getKey(), xmlListChildPair.getValue(), schemaBuilder, instanceBuilder);
        }
        if (schemaNode instanceof NotificationDefinition) {
            instanceBuilder.node(QName.create((String)xmlNode.getNamespaceURI(), (String)xmlNode.getLocalName()));
            schemaBuilder.add(schemaNode.getQName());
            return new NestedNotificationInfo(SchemaNodeIdentifier.Absolute.of(schemaBuilder), DOMDataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (YangInstanceIdentifier)instanceBuilder.build()), xmlNode);
        }
        throw new IllegalStateException("No notification found");
    }

    private static Map.Entry<Node, SchemaNode> findXmlContainerChildPair(Node xmlNode, ContainerSchemaNode container) {
        NodeList nodeList = xmlNode.getChildNodes();
        Map childrenWithoutRevision = Streams.concat((Stream[])new Stream[]{container.getChildNodes().stream(), container.getNotifications().stream()}).collect(Collectors.toMap(child -> child.getQName().withoutRevision(), Function.identity()));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QName currentNodeQName;
            SchemaNode schemaChildNode;
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1 || (schemaChildNode = (SchemaNode)childrenWithoutRevision.get(currentNodeQName = QName.create((String)currentNode.getNamespaceURI(), (String)currentNode.getLocalName()))) == null) continue;
            return Map.entry(currentNode, schemaChildNode);
        }
        throw new IllegalStateException("No container child found.");
    }

    private static Map<QName, Object> findXmlListKeys(Node xmlNode, ListSchemaNode listSchemaNode) {
        HashMap<QName, Object> listKeys = new HashMap<QName, Object>();
        NodeList nodeList = xmlNode.getChildNodes();
        Set keyDefinitionsWithoutRevision = listSchemaNode.getKeyDefinition().stream().map(QName::withoutRevision).collect(Collectors.toSet());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QName currentNodeQName;
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1 || !keyDefinitionsWithoutRevision.contains(currentNodeQName = QName.create((String)currentNode.getNamespaceURI(), (String)currentNode.getLocalName()))) continue;
            listKeys.put(currentNodeQName, currentNode.getFirstChild().getNodeValue());
        }
        if (listKeys.isEmpty()) {
            throw new IllegalStateException("Notification cannot be contained in list without key statement.");
        }
        return listKeys;
    }

    private static Map.Entry<Node, SchemaNode> findXmlListChildPair(Node xmlNode, ListSchemaNode list) {
        NodeList nodeList = xmlNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            QName currentNodeQName = QName.create((String)currentNode.getNamespaceURI(), (String)currentNode.getLocalName());
            for (SchemaNode childNode : Iterables.concat((Iterable)list.getChildNodes(), (Iterable)list.getNotifications())) {
                if (list.getKeyDefinition().contains(childNode.getQName()) || !currentNodeQName.isEqualWithoutRevision(childNode.getQName())) continue;
                return new AbstractMap.SimpleEntry<Node, SchemaNode>(currentNode, childNode);
            }
        }
        throw new IllegalStateException("No list child found.");
    }

    private static NotificationDefinition getMostRecentNotification(Collection<? extends NotificationDefinition> notificationDefinitions) {
        return Collections.max(notificationDefinitions, (o1, o2) -> Revision.compare((Optional)o1.getQName().getRevision(), (Optional)o2.getQName().getRevision()));
    }

    @Override
    public NetconfMessage toRpcRequest(QName rpc, ContainerNode payload) {
        boolean needToUseBaseCtx = this.mappedRpcs.get((Object)rpc) == null && NetconfMessageTransformer.isBaseOrNotificationRpc(rpc);
        ImmutableMap<QName, ? extends RpcDefinition> currentMappedRpcs = needToUseBaseCtx ? this.baseSchema.mappedRpcs() : this.mappedRpcs;
        RpcDefinition mappedRpc = (RpcDefinition)Preconditions.checkNotNull((Object)((RpcDefinition)currentMappedRpcs.get((Object)rpc)), (String)"Unknown rpc %s, available rpcs: %s", (Object)rpc, (Object)currentMappedRpcs.keySet());
        if (mappedRpc.getInput().getChildNodes().isEmpty()) {
            return new NetconfMessage(NetconfMessageTransformUtil.prepareDomResultForRpcRequest(rpc, this.counter).getNode().getOwnerDocument());
        }
        Preconditions.checkNotNull((Object)payload, (String)"Transforming an rpc with input: %s, payload cannot be null", (Object)rpc);
        DOMResult result = NetconfMessageTransformUtil.prepareDomResultForRpcRequest(rpc, this.counter);
        try {
            EffectiveModelContext modelContext = needToUseBaseCtx ? this.baseSchema.modelContext() : this.mountContext.modelContext();
            NetconfMessageTransformUtil.writeNormalizedOperationInput(payload, result, SchemaNodeIdentifier.Absolute.of((QName)rpc), modelContext);
        }
        catch (IOException | IllegalStateException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize input of " + String.valueOf(rpc), e);
        }
        Document node = result.getNode().getOwnerDocument();
        return new NetconfMessage(node);
    }

    @Override
    public NetconfMessage toActionRequest(SchemaNodeIdentifier.Absolute action, DOMDataTreeIdentifier domDataTreeIdentifier, NormalizedNode payload) {
        ActionDefinition actionDef = (ActionDefinition)this.actions.get((Object)action);
        Preconditions.checkArgument((actionDef != null ? 1 : 0) != 0, (String)"Action does not exist: %s", (Object)action);
        InputSchemaNode inputDef = actionDef.getInput();
        if (inputDef.getChildNodes().isEmpty()) {
            return new NetconfMessage(NetconfMessageTransformUtil.prepareDomResultForActionRequest(this.contextTree, domDataTreeIdentifier, this.counter, actionDef.getQName()).getNode().getOwnerDocument());
        }
        Preconditions.checkNotNull((Object)payload, (String)"Transforming an action with input: %s, payload cannot be null", (Object)action);
        Preconditions.checkArgument((boolean)(payload instanceof ContainerNode), (String)"Transforming an action with input: %s, payload has to be a container, but was: %s", (Object)action, (Object)payload);
        DOMResult result = NetconfMessageTransformUtil.prepareDomResultForActionRequest(this.contextTree, domDataTreeIdentifier, this.counter, actionDef.getQName());
        try {
            NetconfMessageTransformUtil.writeNormalizedOperationInput((ContainerNode)payload, result, action, this.mountContext.modelContext());
        }
        catch (IOException | IllegalStateException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize input of " + String.valueOf(action), e);
        }
        return new NetconfMessage(result.getNode().getOwnerDocument());
    }

    private static boolean isBaseOrNotificationRpc(QName rpc) {
        return BASE_OR_NOTIFICATION_NS.contains((Object)rpc.getNamespace());
    }

    @Override
    public synchronized DOMRpcResult toRpcResult(RpcResult<NetconfMessage> resultPayload, QName rpc) {
        ContainerNode normalizedNode;
        if (!resultPayload.isSuccessful()) {
            return new DefaultDOMRpcResult((Collection)resultPayload.getErrors());
        }
        NetconfMessage message = (NetconfMessage)resultPayload.getResult();
        if (NetconfMessageTransformUtil.isDataRetrievalOperation(rpc)) {
            normalizedNode = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_RPC_REPLY_NODEID).withChild((DataContainerChild)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID).withValue((Object)new DOMSource(NetconfMessageTransformUtil.getDataSubtree(message.getDocument()))).build()).build();
        } else {
            ImmutableMap<QName, ? extends RpcDefinition> currentMappedRpcs = this.mappedRpcs.get((Object)rpc) == null && NetconfMessageTransformer.isBaseOrNotificationRpc(rpc) ? this.baseSchema.mappedRpcs() : this.mappedRpcs;
            RpcDefinition rpcDefinition = (RpcDefinition)currentMappedRpcs.get((Object)rpc);
            Preconditions.checkArgument((rpcDefinition != null ? 1 : 0) != 0, (String)"Unable to parse response of %s, the rpc is unknown", (Object)rpc);
            normalizedNode = this.parseResult(message, SchemaNodeIdentifier.Absolute.of((QName)rpc), (OperationDefinition)rpcDefinition);
        }
        return new DefaultDOMRpcResult(normalizedNode);
    }

    @Override
    public DOMRpcResult toActionResult(SchemaNodeIdentifier.Absolute action, NetconfMessage message) {
        ActionDefinition actionDefinition = (ActionDefinition)this.actions.get((Object)action);
        Preconditions.checkArgument((actionDefinition != null ? 1 : 0) != 0, (String)"Action does not exist: %s", (Object)action);
        ContainerNode normalizedNode = this.parseResult(message, action, (OperationDefinition)actionDefinition);
        if (normalizedNode == null) {
            return new DefaultDOMRpcResult(List.of());
        }
        return new DefaultDOMRpcResult(normalizedNode, List.of());
    }

    private ContainerNode parseResult(NetconfMessage message, SchemaNodeIdentifier.Absolute operationPath, OperationDefinition operationDef) {
        Optional okResponseElement = XmlElement.fromDomDocument((Document)message.getDocument()).getOnlyChildElementWithSameNamespaceOptionally("ok");
        OutputSchemaNode operOutput = operationDef.getOutput();
        if (operOutput.getChildNodes().isEmpty()) {
            Preconditions.checkArgument((boolean)okResponseElement.isPresent(), (String)"Unexpected content in response of operation: %s, %s", (Object)operationDef.getQName(), (Object)message);
            return null;
        }
        if (okResponseElement.isPresent()) {
            LOG.debug("Received response <ok/> for RPC with defined Output");
            return null;
        }
        List operSteps = operationPath.getNodeIdentifiers();
        SchemaNodeIdentifier.Absolute outputPath = SchemaNodeIdentifier.Absolute.of((Collection)ImmutableList.builderWithExpectedSize((int)(operSteps.size() + 1)).addAll((Iterable)operSteps).add((Object)operOutput.getQName()).build());
        SchemaInferenceStack.Inference inference = SchemaInferenceStack.of((EffectiveModelContext)this.mountContext.modelContext(), (SchemaNodeIdentifier.Absolute)outputPath).toInference();
        NormalizationResultHolder resultHolder = new NormalizationResultHolder();
        Element element = message.getDocument().getDocumentElement();
        try {
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (MountPointContext)this.mountContext, (EffectiveStatementInference)inference, (boolean)this.strictParsing);
            xmlParser.traverse(new DOMSource(element));
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalArgumentException(String.format("Failed to parse RPC response %s", element), e);
        }
        return (ContainerNode)resultHolder.getResult().data();
    }

    @Beta
    public static class NetconfDeviceNotification
    implements DOMNotification,
    DOMEvent {
        private final ContainerNode content;
        private final SchemaNodeIdentifier.Absolute schemaPath;
        private final Instant eventTime;

        NetconfDeviceNotification(ContainerNode content, Instant eventTime) {
            this.content = content;
            this.eventTime = eventTime;
            this.schemaPath = SchemaNodeIdentifier.Absolute.of((QName)content.name().getNodeType());
        }

        NetconfDeviceNotification(ContainerNode content, SchemaNodeIdentifier.Absolute schemaPath, Instant eventTime) {
            this.content = content;
            this.eventTime = eventTime;
            this.schemaPath = schemaPath;
        }

        public SchemaNodeIdentifier.Absolute getType() {
            return this.schemaPath;
        }

        public ContainerNode getBody() {
            return this.content;
        }

        public Instant getEventInstant() {
            return this.eventTime;
        }
    }

    private static final class NestedNotificationInfo {
        final @NonNull DOMDataTreeIdentifier instancePath;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull SchemaNodeIdentifier.Absolute schemaPath;
        final @NonNull Element element;

        NestedNotificationInfo(SchemaNodeIdentifier.Absolute schemaPath, DOMDataTreeIdentifier instancePath, Node documentNode) {
            this.schemaPath = Objects.requireNonNull(schemaPath);
            this.instancePath = Objects.requireNonNull(instancePath);
            Preconditions.checkArgument((boolean)(documentNode instanceof Element), (String)"Unexpected document node %s", (Object)documentNode);
            this.element = (Element)documentNode;
        }
    }

    @Beta
    public static class NetconfDeviceTreeNotification
    extends NetconfDeviceNotification {
        private final DOMDataTreeIdentifier domDataTreeIdentifier;

        NetconfDeviceTreeNotification(ContainerNode content, SchemaNodeIdentifier.Absolute schemaPath, Instant eventTime, DOMDataTreeIdentifier domDataTreeIdentifier) {
            super(content, schemaPath, eventTime);
            this.domDataTreeIdentifier = domDataTreeIdentifier;
        }

        public DOMDataTreeIdentifier getDomDataTreeIdentifier() {
            return this.domDataTreeIdentifier;
        }
    }
}

