/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.util.concurrent.FutureCallback;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfRpcFutureCallback
implements FutureCallback<DOMRpcResult> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfRpcFutureCallback.class);
    private final String type;
    private final RemoteDeviceId id;

    public NetconfRpcFutureCallback(String prefix, RemoteDeviceId id) {
        this.type = prefix;
        this.id = id;
    }

    public void onSuccess(DOMRpcResult result) {
        if (result.errors().isEmpty()) {
            LOG.trace("{}: {} invoked successfully", (Object)this.id, (Object)this.type);
        } else {
            this.onUnsuccess(result);
        }
    }

    protected void onUnsuccess(DOMRpcResult result) {
        LOG.warn("{}: {} invoked unsuccessfully: {}", new Object[]{this.id, this.type, result.errors()});
    }

    public void onFailure(Throwable throwable) {
        LOG.warn("{}: {} failed.", new Object[]{this.id, this.type, throwable});
    }
}

