/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.impl.FieldsFilter;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.client.mdsal.impl.RpcStructureTransformer;
import org.opendaylight.netconf.common.mdsal.NormalizedDataUtil;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DOMSourceAnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class NetconfRpcStructureTransformer
implements RpcStructureTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfRpcStructureTransformer.class);
    private final MountPointContext mountContext;

    NetconfRpcStructureTransformer(MountPointContext mountContext) {
        this.mountContext = mountContext;
    }

    @Override
    public Optional<NormalizedNode> selectFromDataStructure(DataContainerChild data, YangInstanceIdentifier path) {
        if (data instanceof DOMSourceAnyxmlNode) {
            try {
                NormalizationResultHolder node = NormalizedDataUtil.transformDOMSourceToNormalizedNode((MountPointContext)this.mountContext, (DOMSource)((DOMSourceAnyxmlNode)data).body());
                return NormalizedNodes.findNode((NormalizedNode)node.getResult().data(), (Iterable)path.getPathArguments());
            }
            catch (IOException | URISyntaxException | XMLStreamException | SAXException e) {
                LOG.error("Cannot parse anyxml.", (Throwable)e);
                return Optional.empty();
            }
        }
        return NormalizedNodes.findNode((NormalizedNode)data, (Iterable)path.getPathArguments());
    }

    @Override
    public AnyxmlNode<DOMSource> createEditConfigStructure(Optional<NormalizedNode> data, YangInstanceIdentifier dataPath, Optional<EffectiveOperation> operation) {
        return NetconfMessageTransformUtil.createEditConfigAnyxml(this.mountContext.modelContext(), dataPath, operation, data);
    }

    @Override
    public AnyxmlNode<?> toFilterStructure(YangInstanceIdentifier path) {
        return NetconfMessageTransformUtil.toFilterStructure(path, this.mountContext.modelContext());
    }

    @Override
    public AnyxmlNode<?> toFilterStructure(List<FieldsFilter> fieldsFilters) {
        return NetconfMessageTransformUtil.toFilterStructure(fieldsFilters, this.mountContext.modelContext());
    }
}

