/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.api.NetconfDeviceSchemas;
import org.opendaylight.netconf.client.mdsal.api.NetconfDeviceSchemasResolver;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.ProvidedSources;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.MonitoringSchemaSourceProvider;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.common.mdsal.NormalizedDataUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Get;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.GetInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.input.Filter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public final class NetconfStateSchemasResolverImpl
implements NetconfDeviceSchemasResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfStateSchemasResolverImpl.class);
    private static final String MONITORING_NAMESPACE = NetconfState.QNAME.getNamespace().toString();
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier SCHEMA_FORMAT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"format"));
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier SCHEMA_LOCATION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"location"));
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier SCHEMA_NAMESPACE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"namespace"));
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier SCHEMA_IDENTIFIER_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"identifier"));
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier SCHEMA_VERSION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"version"));
    private static final @NonNull String NETCONF_LOCATION = Schema.Location.Enumeration.NETCONF.getName();
    private static final @NonNull ContainerNode GET_SCHEMAS_RPC;

    @Override
    public ListenableFuture<NetconfDeviceSchemas> resolve(RemoteDeviceId deviceId, NetconfSessionPreferences sessionPreferences, NetconfRpcService deviceRpc, EffectiveModelContext baseModelContext) {
        ListenableFuture<List<ProvidedSources<?>>> monitoringFuture = sessionPreferences.isMonitoringSupported() ? NetconfStateSchemasResolverImpl.resolveMonitoringSources(deviceId, deviceRpc, baseModelContext) : Futures.immediateFuture(List.of());
        LOG.debug("{}: resolving YANG 1.0 conformance", (Object)deviceId);
        AsyncFunction function = sources -> NetconfStateSchemasResolverImpl.resolveYang10(deviceId, sessionPreferences, deviceRpc, baseModelContext, sources);
        return Futures.transformAsync(monitoringFuture, (AsyncFunction)function, (Executor)MoreExecutors.directExecutor());
    }

    private static ListenableFuture<List<ProvidedSources<?>>> resolveMonitoringSources(RemoteDeviceId deviceId, NetconfRpcService deviceRpc, EffectiveModelContext baseModelContext) {
        return Futures.transform(deviceRpc.invokeNetconf(Get.QNAME, GET_SCHEMAS_RPC), result -> NetconfStateSchemasResolverImpl.resolveMonitoringSources(deviceId, deviceRpc, result, baseModelContext), (Executor)MoreExecutors.directExecutor());
    }

    private static List<ProvidedSources<?>> resolveMonitoringSources(RemoteDeviceId deviceId, NetconfRpcService deviceRpc, DOMRpcResult rpcResult, EffectiveModelContext baseModelContext) {
        NormalizedNode normalizedData;
        Collection errors = rpcResult.errors();
        if (errors.stream().anyMatch(error -> error.getSeverity() == ErrorSeverity.ERROR)) {
            LOG.warn("{}: failed to get netconf-state", (Object)errors);
            return List.of();
        }
        for (RpcError error2 : errors) {
            LOG.info("{}: schema retrieval warning: {}", (Object)deviceId, (Object)error2);
        }
        ContainerNode rpcOutput = rpcResult.value();
        if (rpcOutput == null) {
            LOG.warn("{}: missing RPC output", (Object)deviceId);
            return List.of();
        }
        DataContainerChild data = (DataContainerChild)rpcOutput.childByArg((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID);
        if (data == null) {
            LOG.warn("{}: missing RPC data", (Object)deviceId);
            return List.of();
        }
        if (!(data instanceof AnyxmlNode)) {
            LOG.warn("{}: unexpected data {}", (Object)deviceId, (Object)data.prettyTree());
            return List.of();
        }
        AnyxmlNode anyxmlData = (AnyxmlNode)data;
        Object dataBody = anyxmlData.body();
        if (!(dataBody instanceof DOMSource)) {
            LOG.warn("{}: unexpected body {}", (Object)deviceId, dataBody);
            return List.of();
        }
        DOMSource domDataBody = (DOMSource)dataBody;
        DOMSource filteredBody = NetconfStateSchemasResolverImpl.ietfMonitoringCopy(domDataBody);
        try {
            normalizedData = NormalizedDataUtil.transformDOMSourceToNormalizedNode((EffectiveModelContext)baseModelContext, (DOMSource)filteredBody).getResult().data();
        }
        catch (IOException | URISyntaxException | XMLStreamException | SAXException e) {
            LOG.warn("{}: failed to transform {}", new Object[]{deviceId, filteredBody, e});
            return List.of();
        }
        if (!(normalizedData instanceof DataContainerNode)) {
            LOG.warn("{}: unexpected normalized data {}", (Object)deviceId, (Object)normalizedData.prettyTree());
            return List.of();
        }
        DataContainerNode root = (DataContainerNode)normalizedData;
        DataContainerChild netconfState = (DataContainerChild)root.childByArg((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(NetconfState.QNAME));
        if (netconfState == null) {
            LOG.warn("{}: missing netconf-state", (Object)deviceId);
            return List.of();
        }
        if (!(netconfState instanceof ContainerNode)) {
            LOG.warn("{}: unexpected netconf-state {}", (Object)deviceId, (Object)netconfState.prettyTree());
            return List.of();
        }
        ContainerNode netconfStateCont = (ContainerNode)netconfState;
        DataContainerChild schemas = (DataContainerChild)netconfStateCont.childByArg((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Schemas.QNAME));
        if (schemas == null) {
            LOG.warn("{}: missing schemas", (Object)deviceId);
            return List.of();
        }
        if (!(schemas instanceof ContainerNode)) {
            LOG.warn("{}: unexpected schemas {}", (Object)deviceId, (Object)schemas.prettyTree());
            return List.of();
        }
        ContainerNode schemasNode = (ContainerNode)schemas;
        return NetconfStateSchemasResolverImpl.resolveMonitoringSources(deviceId, deviceRpc, schemasNode);
    }

    @VisibleForTesting
    static List<ProvidedSources<?>> resolveMonitoringSources(RemoteDeviceId deviceId, NetconfRpcService deviceRpc, ContainerNode schemasNode) {
        DataContainerChild child = (DataContainerChild)schemasNode.childByArg((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Schema.QNAME));
        if (child == null) {
            LOG.warn("{}: missing schema", (Object)deviceId);
            return List.of();
        }
        if (!(child instanceof SystemMapNode)) {
            LOG.warn("{}: unexpected schema {}", (Object)deviceId, (Object)child.prettyTree());
            return List.of();
        }
        SystemMapNode schemaMap = (SystemMapNode)child;
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)schemaMap.size());
        for (MapEntryNode schemaNode : schemaMap.body()) {
            QName qname = NetconfStateSchemasResolverImpl.createFromNormalizedNode(deviceId, schemaNode);
            if (qname == null) continue;
            builder.add((Object)qname);
        }
        ImmutableSet sources = builder.build();
        return sources.isEmpty() ? List.of() : List.of(new ProvidedSources<YangTextSource>(YangTextSource.class, new MonitoringSchemaSourceProvider(deviceId, deviceRpc), (Set<QName>)sources));
    }

    private static @Nullable QName createFromNormalizedNode(RemoteDeviceId id, MapEntryNode schemaEntry) {
        Object format = ((DataContainerChild)schemaEntry.getChildByArg((YangInstanceIdentifier.PathArgument)SCHEMA_FORMAT_NODEID)).body();
        if (!Yang.QNAME.equals(format)) {
            LOG.debug("{}: Ignoring schema due to unsupported format: {}", (Object)id, format);
            return null;
        }
        String identifier = (String)((DataContainerChild)schemaEntry.getChildByArg((YangInstanceIdentifier.PathArgument)SCHEMA_IDENTIFIER_NODEID)).body();
        String version = (String)((DataContainerChild)schemaEntry.getChildByArg((YangInstanceIdentifier.PathArgument)SCHEMA_VERSION_NODEID)).body();
        LeafNode namespaceLeaf = (LeafNode)schemaEntry.childByArg((YangInstanceIdentifier.PathArgument)SCHEMA_NAMESPACE_NODEID);
        if (namespaceLeaf == null) {
            LOG.warn("{}: Ignoring schema due to missing namespace", (Object)id);
            return null;
        }
        SystemLeafSetNode location = (SystemLeafSetNode)schemaEntry.childByArg((YangInstanceIdentifier.PathArgument)SCHEMA_LOCATION_NODEID);
        if (location == null) {
            LOG.debug("{}: Ignoring schema due to missing location", (Object)id);
            return null;
        }
        boolean foundNetconf = false;
        for (LeafSetEntryNode locEntry : location.body()) {
            String loc = (String)locEntry.body();
            if (NETCONF_LOCATION.equals(loc)) {
                foundNetconf = true;
                break;
            }
            LOG.debug("{}: Ignoring schema due to unsupported location: {}", (Object)id, (Object)loc);
        }
        if (!foundNetconf) {
            LOG.debug("{}: Ignoring schema due to no NETCONF location", (Object)id);
            return null;
        }
        try {
            XMLNamespace namespace = XMLNamespace.of((String)((String)namespaceLeaf.body()));
            Revision revision = version.isEmpty() ? null : Revision.of((String)version);
            return QName.create((XMLNamespace)namespace, (Revision)revision, (String)identifier);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            LOG.warn("{}: Ignoring malformed schema {}", new Object[]{id, schemaEntry.prettyTree(), e});
            return null;
        }
    }

    @VisibleForTesting
    static DOMSource ietfMonitoringCopy(DOMSource domSource) {
        Document sourceDoc = XmlUtil.newDocument();
        sourceDoc.appendChild(sourceDoc.importNode(domSource.getNode(), true));
        TreeWalker treeWalker = ((DocumentTraversal)((Object)sourceDoc)).createTreeWalker(sourceDoc.getDocumentElement(), -1, node -> {
            String namespace = node.getNamespaceURI();
            return (short)(namespace == null || MONITORING_NAMESPACE.equals(namespace) ? 1 : 2);
        }, false);
        Document filteredDoc = XmlUtil.newDocument();
        filteredDoc.appendChild(filteredDoc.importNode(treeWalker.getRoot(), false));
        Element filteredElement = filteredDoc.getDocumentElement();
        NetconfStateSchemasResolverImpl.copyChildren(treeWalker, filteredDoc, filteredElement);
        return new DOMSource(filteredElement);
    }

    private static void copyChildren(TreeWalker walker, Document targetDoc, Node targetNode) {
        if (walker.firstChild() != null) {
            Node node = walker.getCurrentNode();
            while (node != null) {
                Node importedNode = targetDoc.importNode(node, false);
                targetNode.appendChild(importedNode);
                NetconfStateSchemasResolverImpl.copyChildren(walker, targetDoc, importedNode);
                walker.setCurrentNode(node);
                node = walker.nextSibling();
            }
        }
    }

    private static ListenableFuture<NetconfDeviceSchemas> resolveYang10(RemoteDeviceId deviceId, NetconfSessionPreferences sessionPreferences, NetconfRpcService deviceRpc, EffectiveModelContext baseModelContext, List<ProvidedSources<?>> monitoringSources) {
        Sets.SetView providedSourcesNotRequired;
        Set providedSources = monitoringSources.stream().flatMap(sources -> sources.sources().stream()).collect(Collectors.toSet());
        LOG.debug("{}: Schemas exposed by ietf-netconf-monitoring: {}", (Object)deviceId, providedSources);
        HashSet<QName> requiredSources = new HashSet<QName>((Collection<QName>)sessionPreferences.moduleBasedCaps().keySet());
        Sets.SetView requiredSourcesNotProvided = Sets.difference(requiredSources, providedSources);
        if (!requiredSourcesNotProvided.isEmpty()) {
            LOG.warn("{}: Netconf device does not provide all yang models reported in hello message capabilities, required but not provided: {}", (Object)deviceId, (Object)requiredSourcesNotProvided);
            LOG.warn("{}: Attempting to build schema context from required sources", (Object)deviceId);
        }
        if (!(providedSourcesNotRequired = Sets.difference(providedSources, requiredSources)).isEmpty()) {
            LOG.warn("{}: Netconf device provides additional yang models not reported in hello message capabilities: {}", (Object)deviceId, (Object)providedSourcesNotRequired);
            LOG.warn("{}: Adding provided but not required sources as required to prevent failures", (Object)deviceId);
            LOG.debug("{}: Netconf device reported in hello: {}", (Object)deviceId, requiredSources);
            requiredSources.addAll((Collection<QName>)providedSourcesNotRequired);
        }
        return Futures.immediateFuture((Object)new NetconfDeviceSchemas(requiredSources, FeatureSet.builder().build(), Set.of(), monitoringSources));
    }

    static {
        Document document = XmlUtil.newDocument();
        Element filterElem = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "filter");
        filterElem.setAttribute("type", "subtree");
        Element stateElem = document.createElementNS(NetconfState.QNAME.getNamespace().toString(), NetconfState.QNAME.getLocalName());
        stateElem.appendChild(document.createElementNS(Schemas.QNAME.getNamespace().toString(), Schemas.QNAME.getLocalName()));
        filterElem.appendChild(stateElem);
        GET_SCHEMAS_RPC = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(GetInput.QNAME)).withChild((DataContainerChild)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Filter.QNAME)).withValue((Object)new DOMSource(filterElem)).build()).build();
    }
}

