/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.opendaylight.netconf.client.mdsal.NetconfDevice;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCapabilities;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.NetconfDeviceSchemas;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.available.capabilities.AvailableCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.unavailable.capabilities.UnavailableCapability;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SchemaSetup
implements FutureCallback<EffectiveModelContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaSetup.class);
    private final SettableFuture<DeviceNetconfSchema> resultFuture = SettableFuture.create();
    private final Set<AvailableCapability> nonModuleBasedCapabilities = new HashSet<AvailableCapability>();
    private final Map<QName, UnavailableCapability.FailureReason> unresolvedCapabilites = new HashMap<QName, UnavailableCapability.FailureReason>();
    private final Set<AvailableCapability> resolvedCapabilities = new HashSet<AvailableCapability>();
    private final RemoteDeviceId deviceId;
    private final NetconfDeviceSchemas deviceSchemas;
    private final Set<QName> deviceRequiredSources;
    private final NetconfSessionPreferences sessionPreferences;
    private final SchemaRepository repository;
    private final EffectiveModelContextFactory contextFactory;
    private Collection<SourceIdentifier> requiredSources;

    SchemaSetup(SchemaRepository repository, EffectiveModelContextFactory contextFactory, RemoteDeviceId deviceId, NetconfDeviceSchemas deviceSchemas, NetconfSessionPreferences sessionPreferences) {
        this.repository = Objects.requireNonNull(repository);
        this.contextFactory = Objects.requireNonNull(contextFactory);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.deviceSchemas = Objects.requireNonNull(deviceSchemas);
        this.sessionPreferences = Objects.requireNonNull(sessionPreferences);
        this.deviceRequiredSources = new HashSet<QName>(deviceSchemas.requiredSources());
        if (sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:notification:1.0")) {
            this.deviceRequiredSources.add(YangModuleInfoImpl.getInstance().getName());
            this.deviceRequiredSources.add(org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangModuleInfoImpl.getInstance().getName());
        }
        this.requiredSources = this.deviceRequiredSources.stream().map(qname -> new SourceIdentifier(qname.getLocalName(), (Revision)qname.getRevision().orElse(null))).collect(Collectors.toList());
        List<SourceIdentifier> missingSources = this.filterMissingSources(this.requiredSources);
        this.addUnresolvedCapabilities(this.getQNameFromSourceIdentifiers(missingSources), UnavailableCapability.FailureReason.MissingSource);
        this.requiredSources.removeAll(missingSources);
    }

    ListenableFuture<DeviceNetconfSchema> startResolution() {
        this.trySetupSchema();
        return this.resultFuture;
    }

    public void onSuccess(EffectiveModelContext result) {
        LOG.debug("{}: Schema context built successfully from {}", (Object)this.deviceId, this.requiredSources);
        Sets.SetView filteredQNames = Sets.difference(this.deviceRequiredSources, this.unresolvedCapabilites.keySet());
        this.resolvedCapabilities.addAll(filteredQNames.stream().map(capability -> new AvailableCapabilityBuilder().setCapability(capability.toString()).setCapabilityOrigin(this.sessionPreferences.capabilityOrigin((QName)capability)).build()).collect(Collectors.toList()));
        this.nonModuleBasedCapabilities.addAll(this.sessionPreferences.nonModuleCaps().keySet().stream().map(capability -> new AvailableCapabilityBuilder().setCapability((String)capability).setCapabilityOrigin(this.sessionPreferences.capabilityOrigin((String)capability)).build()).collect(Collectors.toList()));
        this.resultFuture.set((Object)new DeviceNetconfSchema(new NetconfDeviceCapabilities((ImmutableMap<QName, UnavailableCapability.FailureReason>)ImmutableMap.copyOf(this.unresolvedCapabilites), (ImmutableSet<AvailableCapability>)ImmutableSet.copyOf(this.resolvedCapabilities), (ImmutableSet<AvailableCapability>)ImmutableSet.copyOf(this.nonModuleBasedCapabilities)), result));
    }

    public void onFailure(Throwable cause) {
        if (cause instanceof MissingSchemaSourceException) {
            this.requiredSources = this.handleMissingSchemaSourceException((MissingSchemaSourceException)cause);
        } else if (cause instanceof SchemaResolutionException) {
            this.requiredSources = this.handleSchemaResolutionException((SchemaResolutionException)cause);
        } else {
            LOG.debug("Unhandled failure", cause);
            this.resultFuture.setException(cause);
            return;
        }
        this.trySetupSchema();
    }

    private void trySetupSchema() {
        if (!this.requiredSources.isEmpty()) {
            LOG.trace("{}: Trying to build schema context from {}", (Object)this.deviceId, this.requiredSources);
            Futures.addCallback((ListenableFuture)this.contextFactory.createEffectiveModelContext(this.requiredSources), (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
        } else {
            LOG.debug("{}: no more sources for schema context", (Object)this.deviceId);
            this.resultFuture.setException((Throwable)new NetconfDevice.EmptySchemaContextException(String.valueOf(this.deviceId) + ": No more sources for schema context"));
        }
    }

    private List<SourceIdentifier> filterMissingSources(Collection<SourceIdentifier> origSources) {
        return origSources.parallelStream().filter(sourceId -> {
            try {
                this.repository.getSchemaSource(sourceId, YangTextSource.class).get();
                return false;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Failed to acquire source {}", sourceId, (Object)e);
                return true;
            }
        }).collect(Collectors.toList());
    }

    private void addUnresolvedCapabilities(Collection<QName> capabilities, UnavailableCapability.FailureReason reason) {
        for (QName s : capabilities) {
            this.unresolvedCapabilites.put(s, reason);
        }
    }

    private List<SourceIdentifier> handleMissingSchemaSourceException(MissingSchemaSourceException exception) {
        SourceIdentifier missingSource = exception.sourceId();
        LOG.warn("{}: Unable to build schema context, missing source {}, will reattempt without it", (Object)this.deviceId, (Object)missingSource);
        LOG.debug("{}: Unable to build schema context, missing source {}, will reattempt without it", new Object[]{this.deviceId, missingSource, exception});
        Collection<QName> qNameOfMissingSource = this.getQNameFromSourceIdentifiers(Sets.newHashSet((Object[])new SourceIdentifier[]{missingSource}));
        if (!qNameOfMissingSource.isEmpty()) {
            this.addUnresolvedCapabilities(qNameOfMissingSource, UnavailableCapability.FailureReason.MissingSource);
        }
        return this.stripUnavailableSource(missingSource);
    }

    private Collection<SourceIdentifier> handleSchemaResolutionException(SchemaResolutionException resolutionException) {
        SourceIdentifier failedSourceId = resolutionException.sourceId();
        if (failedSourceId != null) {
            LOG.warn("{}: Unable to build schema context, failed to resolve source {}, will reattempt without it", (Object)this.deviceId, (Object)failedSourceId);
            LOG.warn("{}: Unable to build schema context, failed to resolve source {}, will reattempt without it", new Object[]{this.deviceId, failedSourceId, resolutionException});
            this.addUnresolvedCapabilities(this.getQNameFromSourceIdentifiers(List.of(failedSourceId)), UnavailableCapability.FailureReason.UnableToResolve);
            return this.stripUnavailableSource(failedSourceId);
        }
        this.addUnresolvedCapabilities(this.getQNameFromSourceIdentifiers(resolutionException.getUnsatisfiedImports().keySet()), UnavailableCapability.FailureReason.UnableToResolve);
        LOG.warn("{}: Unable to build schema context, unsatisfied imports {}, will reattempt with resolved only", (Object)this.deviceId, (Object)resolutionException.getUnsatisfiedImports());
        LOG.debug("{}: Unable to build schema context, unsatisfied imports {}, will reattempt with resolved only", new Object[]{this.deviceId, resolutionException.getUnsatisfiedImports(), resolutionException});
        return resolutionException.getResolvedSources();
    }

    private List<SourceIdentifier> stripUnavailableSource(SourceIdentifier sourceIdToRemove) {
        ArrayList<SourceIdentifier> tmp = new ArrayList<SourceIdentifier>(this.requiredSources);
        Preconditions.checkState((boolean)tmp.remove(sourceIdToRemove), (String)"%s: Trying to remove %s from %s failed", (Object)this.deviceId, (Object)sourceIdToRemove, this.requiredSources);
        return tmp;
    }

    private Collection<QName> getQNameFromSourceIdentifiers(Collection<SourceIdentifier> identifiers) {
        Collection qNames = Collections2.transform(identifiers, this::getQNameFromSourceIdentifier);
        if (qNames.isEmpty()) {
            LOG.debug("{}: Unable to map any source identifiers to a capability reported by device : {}", (Object)this.deviceId, identifiers);
        }
        return Collections2.filter((Collection)qNames, (Predicate)Predicates.notNull());
    }

    private QName getQNameFromSourceIdentifier(SourceIdentifier identifier) {
        for (QName qname : this.deviceRequiredSources) {
            if (!qname.getLocalName().equals(identifier.name().getLocalName()) || !Objects.equals(identifier.revision(), qname.getRevision().orElse(null))) continue;
            return qname;
        }
        LOG.warn("Unable to map identifier to a devices reported capability: {} Available: {}", (Object)identifier, this.deviceRequiredSources);
        return null;
    }
}

