/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import java.time.Instant;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.client.mdsal.api.NotificationTransformer;
import org.opendaylight.netconf.client.mdsal.api.RpcTransformer;
import org.opendaylight.netconf.client.mdsal.impl.BaseRpcSchemalessTransformer;
import org.opendaylight.netconf.client.mdsal.impl.MessageCounter;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemalessMessageTransformer
implements NotificationTransformer,
RpcTransformer<DOMSource, DOMSource> {
    public static final YangInstanceIdentifier.NodeIdentifier SCHEMALESS_NOTIFICATION_PAYLOAD = new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"", (String)"schemaless-notification-payload"));
    private final MessageCounter counter;

    public SchemalessMessageTransformer(MessageCounter counter) {
        this.counter = counter;
    }

    @Override
    public DOMNotification toNotification(NetconfMessage message) {
        QName notificationNoRev;
        Map.Entry<Instant, XmlElement> stripped = NetconfMessageTransformUtil.stripNotification(message);
        try {
            notificationNoRev = QName.create((String)stripped.getValue().getNamespace(), (String)stripped.getValue().getName()).withoutRevision();
        }
        catch (MissingNameSpaceException e) {
            throw new IllegalArgumentException("Unable to parse notification " + String.valueOf(message) + ", cannot find namespace", e);
        }
        return new NetconfMessageTransformer.NetconfDeviceNotification((ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)SCHEMALESS_NOTIFICATION_PAYLOAD).withChild((DataContainerChild)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(notificationNoRev)).withValue((Object)new DOMSource(stripped.getValue().getDomElement())).build()).build(), stripped.getKey());
    }

    @Override
    public NetconfMessage toRpcRequest(QName rpc, DOMSource payload) {
        this.wrapPayload((Document)payload.getNode());
        return new NetconfMessage((Document)payload.getNode());
    }

    @Override
    public DOMSource toRpcResult(RpcResult<NetconfMessage> resultPayload, QName rpc) {
        Document document = ((NetconfMessage)resultPayload.getResult()).getDocument();
        return BaseRpcSchemalessTransformer.isOkPresent(document) ? null : new DOMSource(document);
    }

    private void wrapPayload(Document doc) {
        Element payload = doc.getDocumentElement();
        doc.removeChild(payload);
        Element rpcNS = doc.createElementNS(NetconfMessageTransformUtil.NETCONF_RPC_QNAME.getNamespace().toString(), NetconfMessageTransformUtil.NETCONF_RPC_QNAME.getLocalName());
        rpcNS.setAttribute("message-id", this.counter.getNewMessageId("m"));
        rpcNS.appendChild(payload);
        doc.appendChild(rpcNS);
    }
}

