/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.impl.FieldsFilter;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.client.mdsal.impl.RpcStructureTransformer;
import org.opendaylight.netconf.common.mdsal.NormalizedDataUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.input.Filter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DOMSourceAnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SchemalessRpcStructureTransformer
implements RpcStructureTransformer {
    SchemalessRpcStructureTransformer() {
    }

    @Override
    public Optional<NormalizedNode> selectFromDataStructure(DataContainerChild data, YangInstanceIdentifier path) {
        if (!(data instanceof DOMSourceAnyxmlNode)) {
            throw new IllegalArgumentException("Unexpected data " + String.valueOf(data.prettyTree()));
        }
        DOMSourceAnyxmlNode anyxml = (DOMSourceAnyxmlNode)data;
        Document result = XmlUtil.newDocument();
        Element dataElement = result.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "data");
        result.appendChild(dataElement);
        for (XmlElement xmlElement : SchemalessRpcStructureTransformer.selectMatchingNodes(SchemalessRpcStructureTransformer.getSourceElement(anyxml.body()), path)) {
            dataElement.appendChild(result.importNode(xmlElement.getDomElement(), true));
        }
        return Optional.of(ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID).withValue((Object)new DOMSource(result)).build());
    }

    @Override
    public AnyxmlNode<DOMSource> createEditConfigStructure(Optional<NormalizedNode> data, YangInstanceIdentifier dataPath, Optional<EffectiveOperation> operation) {
        Element parentXmlStructure;
        NormalizedNode dataValue = data.orElseThrow();
        if (!(dataValue instanceof DOMSourceAnyxmlNode)) {
            throw new IllegalArgumentException("Unexpected data " + String.valueOf(dataValue.prettyTree()));
        }
        DOMSourceAnyxmlNode anxmlData = (DOMSourceAnyxmlNode)dataValue;
        Document document = XmlUtil.newDocument();
        Element dataNode = (Element)document.importNode(SchemalessRpcStructureTransformer.getSourceElement(anxmlData.body()), true);
        SchemalessRpcStructureTransformer.checkDataValidForPath(dataPath, dataNode);
        Element configElement = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "config");
        document.appendChild(configElement);
        if (dataPath.isEmpty()) {
            parentXmlStructure = dataNode;
            configElement.appendChild(parentXmlStructure);
        } else {
            List pathArguments = dataPath.getPathArguments();
            parentXmlStructure = SchemalessRpcStructureTransformer.instanceIdToXmlStructure(pathArguments.subList(0, pathArguments.size() - 1), configElement);
        }
        operation.ifPresent(modifyAction -> SchemalessRpcStructureTransformer.setOperationAttribute(modifyAction, document, dataNode));
        parentXmlStructure.appendChild(document.importNode(dataNode, true));
        return (AnyxmlNode)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_CONFIG_NODEID).withValue((Object)new DOMSource(document.getDocumentElement())).build();
    }

    @Override
    public AnyxmlNode<?> toFilterStructure(YangInstanceIdentifier path) {
        Document document = XmlUtil.newDocument();
        SchemalessRpcStructureTransformer.instanceIdToXmlStructure(path.getPathArguments(), SchemalessRpcStructureTransformer.prepareFilterElement(document));
        return SchemalessRpcStructureTransformer.buildFilterXmlNode(document);
    }

    @Override
    public AnyxmlNode<?> toFilterStructure(List<FieldsFilter> fieldsFilters) {
        Document document = XmlUtil.newDocument();
        Element filterElement = SchemalessRpcStructureTransformer.prepareFilterElement(document);
        for (FieldsFilter filter : fieldsFilters) {
            NormalizedDataUtil.writeSchemalessFilter((YangInstanceIdentifier)filter.path(), filter.fields(), (Element)filterElement);
        }
        return SchemalessRpcStructureTransformer.buildFilterXmlNode(document);
    }

    private static Element prepareFilterElement(Document document) {
        Element filter = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "filter");
        filter.setAttribute("type", "subtree");
        document.appendChild(filter);
        return filter;
    }

    private static AnyxmlNode<?> buildFilterXmlNode(Document document) {
        return (AnyxmlNode)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Filter.QNAME)).withValue((Object)new DOMSource(document.getDocumentElement())).build();
    }

    private static void checkDataValidForPath(YangInstanceIdentifier dataPath, Element dataNode) {
        if (dataPath.isEmpty()) {
            return;
        }
        XmlElement dataElement = XmlElement.fromDomElement((Element)dataNode);
        YangInstanceIdentifier.PathArgument lastPathArgument = dataPath.getLastPathArgument();
        QName nodeType = lastPathArgument.getNodeType();
        if (!nodeType.getNamespace().toString().equals(dataNode.getNamespaceURI()) || !nodeType.getLocalName().equals(dataElement.getName())) {
            throw new IllegalStateException(String.format("Can't write data '%s' to path %s", dataNode.getTagName(), dataPath));
        }
        if (lastPathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            SchemalessRpcStructureTransformer.checkKeyValuesValidForPath(dataElement, lastPathArgument);
        }
    }

    private static void checkKeyValuesValidForPath(XmlElement dataElement, YangInstanceIdentifier.PathArgument lastPathArgument) {
        for (Map.Entry entry : ((YangInstanceIdentifier.NodeIdentifierWithPredicates)lastPathArgument).entrySet()) {
            String textContent;
            QName qname = (QName)entry.getKey();
            List key = dataElement.getChildElementsWithinNamespace(qname.getLocalName(), qname.getNamespace().toString());
            if (key.isEmpty()) {
                throw new IllegalStateException("No key present in xml");
            }
            if (key.size() > 1) {
                throw new IllegalStateException("Multiple values for same key present");
            }
            try {
                textContent = ((XmlElement)key.get(0)).getTextContent();
            }
            catch (DocumentedException e) {
                throw new IllegalStateException("Key value not present in key element", e);
            }
            if (entry.getValue().equals(textContent)) continue;
            throw new IllegalStateException("Key value in path not equal to key value in xml");
        }
    }

    private static void setOperationAttribute(EffectiveOperation operation, Document document, Element dataNode) {
        Attr operationAttribute = document.createAttributeNS("urn:ietf:params:xml:ns:netconf:base:1.0", "operation");
        operationAttribute.setTextContent(operation.xmlValue());
        dataNode.setAttributeNode(operationAttribute);
    }

    private static Element instanceIdToXmlStructure(List<YangInstanceIdentifier.PathArgument> pathArguments, Element data) {
        Document doc = data.getOwnerDocument();
        Element parent = data;
        for (YangInstanceIdentifier.PathArgument pathArgument : pathArguments) {
            QName nodeType = pathArgument.getNodeType();
            Element element = doc.createElementNS(nodeType.getNamespace().toString(), nodeType.getLocalName());
            parent.appendChild(element);
            if (pathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
                NormalizedDataUtil.appendListKeyNodes((Element)element, (YangInstanceIdentifier.NodeIdentifierWithPredicates)nip);
            }
            parent = element;
        }
        return parent;
    }

    private static List<XmlElement> selectMatchingNodes(Element domElement, YangInstanceIdentifier path) {
        XmlElement element = XmlElement.fromDomElement((Element)domElement);
        for (YangInstanceIdentifier.PathArgument pathArgument : path.getPathArguments()) {
            List childElements = element.getChildElements(pathArgument.getNodeType().getLocalName());
            if (childElements.size() == 1) {
                element = (XmlElement)childElements.get(0);
                continue;
            }
            return childElements;
        }
        return List.of(element);
    }

    private static Element getSourceElement(DOMSource source) {
        Node node = source.getNode();
        return switch (node.getNodeType()) {
            case 9 -> ((Document)node).getDocumentElement();
            case 1 -> (Element)node;
            default -> throw new IllegalStateException("DOMSource node must be document or element.");
        };
    }
}

