/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcFutureCallback;
import org.opendaylight.netconf.dom.api.NetconfDataTreeService;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract sealed class AbstractNetconfDataTreeService
implements NetconfDataTreeService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfDataTreeService.class);
    private static final ListenableFuture<DOMRpcResult> RPC_SUCCESS = Futures.immediateFuture((Object)new DefaultDOMRpcResult(new RpcError[0]));
    final @NonNull RemoteDeviceId id;
    final NetconfBaseOps netconfOps;
    final boolean rollbackSupport;
    private final boolean lockDatastore;

    AbstractNetconfDataTreeService(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean lockDatastore) {
        this.id = Objects.requireNonNull(id);
        this.netconfOps = Objects.requireNonNull(netconfOps);
        this.rollbackSupport = rollbackSupport;
        this.lockDatastore = lockDatastore;
    }

    public static @NonNull AbstractNetconfDataTreeService of(RemoteDeviceId id, MountPointContext mountContext, RemoteDeviceServices.Rpcs rpcs, NetconfSessionPreferences sessionPreferences, boolean lockDatastore) {
        NetconfBaseOps netconfOps = new NetconfBaseOps(rpcs, mountContext);
        boolean rollbackSupport = sessionPreferences.isRollbackSupported();
        if (sessionPreferences.isCandidateSupported()) {
            return sessionPreferences.isRunningWritable() ? new CandidateWithRunning(id, netconfOps, rollbackSupport, lockDatastore) : new Candidate(id, netconfOps, rollbackSupport, lockDatastore);
        }
        if (sessionPreferences.isRunningWritable()) {
            return new Running(id, netconfOps, rollbackSupport, lockDatastore);
        }
        throw new IllegalArgumentException("Device " + id.name() + " has advertised neither :writable-running nor :candidate capability. Failed to establish session, as at least one of these must be advertised.");
    }

    public synchronized ListenableFuture<DOMRpcResult> lock() {
        if (!this.lockDatastore) {
            LOG.trace("Lock is not allowed by device configuration, ignoring lock results: {}", (Object)this.id);
            return RPC_SUCCESS;
        }
        ListenableFuture<DOMRpcResult> result = AbstractNetconfDataTreeService.mergeFutures(this.lockImpl());
        Futures.addCallback(result, (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult result) {
                Collection errors = result.errors();
                if (errors.isEmpty()) {
                    LOG.debug("{}: Lock successful.", (Object)AbstractNetconfDataTreeService.this.id);
                    return;
                }
                if (AbstractNetconfDataTreeService.allWarnings(errors)) {
                    LOG.info("{}: Lock successful with warnings {}", (Object)errors, (Object)AbstractNetconfDataTreeService.this.id);
                    return;
                }
                LOG.warn("{}: Lock failed with errors {}", (Object)AbstractNetconfDataTreeService.this.id, (Object)errors);
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("{}: Lock failed.", (Object)AbstractNetconfDataTreeService.this.id, (Object)throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    List<ListenableFuture<? extends DOMRpcResult>> lockImpl() {
        return List.of(this.lockSingle());
    }

    abstract ListenableFuture<? extends DOMRpcResult> lockSingle();

    public synchronized ListenableFuture<DOMRpcResult> unlock() {
        if (!this.lockDatastore) {
            LOG.trace("Unlock is not allowed: {}", (Object)this.id);
            return RPC_SUCCESS;
        }
        ListenableFuture<DOMRpcResult> result = AbstractNetconfDataTreeService.mergeFutures(this.unlockImpl());
        Futures.addCallback(result, (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult result) {
                Collection errors = result.errors();
                if (errors.isEmpty()) {
                    LOG.debug("{}: Unlock successful.", (Object)AbstractNetconfDataTreeService.this.id);
                    return;
                }
                if (AbstractNetconfDataTreeService.allWarnings(errors)) {
                    LOG.info("{}: Unlock successful with warnings {}", (Object)errors, (Object)AbstractNetconfDataTreeService.this.id);
                    return;
                }
                LOG.error("{}: Unlock failed with errors {}", (Object)AbstractNetconfDataTreeService.this.id, (Object)errors);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("{}: Unlock failed.", (Object)AbstractNetconfDataTreeService.this.id, (Object)throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    abstract List<ListenableFuture<? extends DOMRpcResult>> unlockImpl();

    public ListenableFuture<Optional<NormalizedNode>> get(YangInstanceIdentifier path) {
        return this.netconfOps.getData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path));
    }

    public ListenableFuture<Optional<NormalizedNode>> get(YangInstanceIdentifier path, List<YangInstanceIdentifier> fields) {
        return this.netconfOps.getData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path), fields);
    }

    public ListenableFuture<Optional<NormalizedNode>> getConfig(YangInstanceIdentifier path) {
        return this.netconfOps.getConfigRunningData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path));
    }

    public ListenableFuture<Optional<NormalizedNode>> getConfig(YangInstanceIdentifier path, List<YangInstanceIdentifier> fields) {
        return this.netconfOps.getConfigRunningData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path), fields);
    }

    public synchronized ListenableFuture<? extends DOMRpcResult> merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data, Optional<EffectiveOperation> defaultOperation) {
        AbstractNetconfDataTreeService.checkEditable(store);
        return this.editConfig((DataContainerChild)this.netconfOps.createEditConfigStructure(Optional.ofNullable(data), Optional.of(EffectiveOperation.MERGE), path), defaultOperation.orElse(null));
    }

    public synchronized ListenableFuture<? extends DOMRpcResult> replace(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data, Optional<EffectiveOperation> defaultOperation) {
        AbstractNetconfDataTreeService.checkEditable(store);
        return this.editConfig((DataContainerChild)this.netconfOps.createEditConfigStructure(Optional.ofNullable(data), Optional.of(EffectiveOperation.REPLACE), path), defaultOperation.orElse(null));
    }

    public synchronized ListenableFuture<? extends DOMRpcResult> create(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data, Optional<EffectiveOperation> defaultOperation) {
        AbstractNetconfDataTreeService.checkEditable(store);
        return this.editConfig((DataContainerChild)this.netconfOps.createEditConfigStructure(Optional.ofNullable(data), Optional.of(EffectiveOperation.CREATE), path), defaultOperation.orElse(null));
    }

    public synchronized ListenableFuture<? extends DOMRpcResult> delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.editConfig((DataContainerChild)this.netconfOps.createEditConfigStructure(Optional.empty(), Optional.of(EffectiveOperation.DELETE), path), null);
    }

    public synchronized ListenableFuture<? extends DOMRpcResult> remove(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.editConfig((DataContainerChild)this.netconfOps.createEditConfigStructure(Optional.empty(), Optional.of(EffectiveOperation.REMOVE), path), null);
    }

    public synchronized ListenableFuture<? extends DOMRpcResult> commit() {
        return this.netconfOps.commit(new NetconfRpcFutureCallback("Commit", this.id));
    }

    public final Object getDeviceId() {
        return this.id;
    }

    abstract ListenableFuture<? extends DOMRpcResult> editConfig(DataContainerChild var1, @Nullable EffectiveOperation var2);

    private static void checkEditable(LogicalDatastoreType store) {
        Preconditions.checkArgument((store == LogicalDatastoreType.CONFIGURATION ? 1 : 0) != 0, (String)"Can only edit configuration data, not %s", (Object)store);
    }

    private static ListenableFuture<DOMRpcResult> mergeFutures(List<ListenableFuture<? extends DOMRpcResult>> futures) {
        return Futures.whenAllComplete(futures).call(() -> {
            if (futures.size() == 1) {
                return (DOMRpcResult)Futures.getDone((Future)((Future)futures.get(0)));
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenableFuture future : futures) {
                builder.addAll((Iterable)((DOMRpcResult)Futures.getDone((Future)future)).errors());
            }
            return new DefaultDOMRpcResult(null, (Collection)builder.build());
        }, MoreExecutors.directExecutor());
    }

    private static boolean allWarnings(Collection<? extends @NonNull RpcError> errors) {
        return errors.stream().allMatch(error -> error.getSeverity() == ErrorSeverity.WARNING);
    }

    private static final class CandidateWithRunning
    extends AbstractNetconfDataTreeService {
        private final Candidate candidate;
        private final Running running;

        CandidateWithRunning(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean lockDatastore) {
            super(id, netconfOps, rollbackSupport, lockDatastore);
            this.candidate = new Candidate(id, netconfOps, rollbackSupport, lockDatastore);
            this.running = new Running(id, netconfOps, rollbackSupport, lockDatastore);
        }

        public ListenableFuture<? extends DOMRpcResult> discardChanges() {
            return this.candidate.discardChanges();
        }

        ListenableFuture<DOMRpcResult> lockSingle() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ListenableFuture<? extends DOMRpcResult>> lockImpl() {
            return List.of(this.candidate.lockSingle(), this.running.lockSingle());
        }

        @Override
        List<ListenableFuture<? extends DOMRpcResult>> unlockImpl() {
            return List.of(this.running.unlock(), this.candidate.unlock());
        }

        @Override
        ListenableFuture<? extends DOMRpcResult> editConfig(DataContainerChild editStructure, EffectiveOperation defaultOperation) {
            return this.candidate.editConfig(editStructure, defaultOperation);
        }
    }

    private static final class Candidate
    extends AbstractNetconfDataTreeService {
        Candidate(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean lockDatastore) {
            super(id, netconfOps, rollbackSupport, lockDatastore);
        }

        public ListenableFuture<? extends DOMRpcResult> discardChanges() {
            return this.netconfOps.discardChanges(new NetconfRpcFutureCallback("Discard candidate", this.id));
        }

        @Override
        ListenableFuture<? extends DOMRpcResult> lockSingle() {
            return this.netconfOps.lockCandidate(new NetconfRpcFutureCallback("Lock candidate", this.id));
        }

        @Override
        List<ListenableFuture<? extends DOMRpcResult>> unlockImpl() {
            return List.of(this.netconfOps.unlockCandidate(new NetconfRpcFutureCallback("Unlock candidate", this.id)));
        }

        @Override
        ListenableFuture<? extends DOMRpcResult> editConfig(DataContainerChild editStructure, EffectiveOperation defaultOperation) {
            NetconfRpcFutureCallback callback = new NetconfRpcFutureCallback("Edit candidate", this.id);
            return defaultOperation == null ? this.netconfOps.editConfigCandidate(callback, editStructure, this.rollbackSupport) : this.netconfOps.editConfigCandidate(callback, editStructure, defaultOperation, this.rollbackSupport);
        }
    }

    private static final class Running
    extends AbstractNetconfDataTreeService {
        Running(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean lockDatastore) {
            super(id, netconfOps, rollbackSupport, lockDatastore);
        }

        public ListenableFuture<DOMRpcResult> discardChanges() {
            return RPC_SUCCESS;
        }

        public ListenableFuture<DOMRpcResult> commit() {
            return RPC_SUCCESS;
        }

        @Override
        ListenableFuture<? extends DOMRpcResult> lockSingle() {
            return this.netconfOps.lockRunning(new NetconfRpcFutureCallback("Lock running", this.id));
        }

        @Override
        List<ListenableFuture<? extends DOMRpcResult>> unlockImpl() {
            return List.of(this.netconfOps.unlockRunning(new NetconfRpcFutureCallback("Unlock running", this.id)));
        }

        @Override
        ListenableFuture<? extends DOMRpcResult> editConfig(DataContainerChild editStructure, EffectiveOperation defaultOperation) {
            NetconfRpcFutureCallback callback = new NetconfRpcFutureCallback("Edit running", this.id);
            return defaultOperation == null ? this.netconfOps.editConfigRunning(callback, editStructure, this.rollbackSupport) : this.netconfOps.editConfigRunning(callback, editStructure, defaultOperation, this.rollbackSupport);
        }
    }
}

