/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcFutureCallback;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReadOnlyTx
implements DOMDataTreeReadTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadOnlyTx.class);
    final NetconfBaseOps netconfOps;
    final RemoteDeviceId id;

    AbstractReadOnlyTx(NetconfBaseOps netconfOps, RemoteDeviceId id) {
        this.netconfOps = netconfOps;
        this.id = id;
    }

    private FluentFuture<Optional<NormalizedNode>> readConfigurationData(YangInstanceIdentifier path) {
        return AbstractReadOnlyTx.remapException(this.netconfOps.getConfigRunningData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path)));
    }

    private FluentFuture<Optional<NormalizedNode>> readOperationalData(YangInstanceIdentifier path) {
        return AbstractReadOnlyTx.remapException(this.netconfOps.getData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path)));
    }

    static final <T> @NonNull FluentFuture<T> remapException(ListenableFuture<T> input) {
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback(input, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                ret.set(result);
            }

            public void onFailure(Throwable cause) {
                ret.setException(cause instanceof ReadFailedException ? cause : new ReadFailedException("NETCONF operation failed", cause, new RpcError[0]));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return FluentFuture.from((ListenableFuture)ret);
    }

    public final void close() {
    }

    public final FluentFuture<Optional<NormalizedNode>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return switch (store) {
            case LogicalDatastoreType.CONFIGURATION -> this.readConfigurationData(path);
            case LogicalDatastoreType.OPERATIONAL -> this.readOperationalData(path);
            default -> {
                LOG.info("Unknown datastore type: {}.", (Object)store);
                throw new IllegalArgumentException(String.format("%s, Cannot read data %s for %s datastore, unknown datastore type", this.id, path, store));
            }
        };
    }

    public final FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.read(store, path).transform(optionalNode -> optionalNode != null && optionalNode.isPresent(), MoreExecutors.directExecutor());
    }

    public final Object getIdentifier() {
        return this;
    }
}

