/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.netconf.client.mdsal.spi.AbstractWriteTx;
import org.opendaylight.netconf.client.mdsal.spi.TxListener;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Empty;

abstract class AbstractTxChain
implements DOMTransactionChain,
TxListener {
    private final Map<DOMDataTreeWriteTransaction, Registration> pendingTransactions = new HashMap<DOMDataTreeWriteTransaction, Registration>();
    private final @NonNull SettableFuture<Empty> future = SettableFuture.create();
    final DOMDataBroker dataBroker;
    private AbstractWriteTx currentTransaction = null;
    private boolean closed = false;
    private boolean successful = true;

    AbstractTxChain(DOMDataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    public final ListenableFuture<Empty> future() {
        return this.future;
    }

    public final synchronized AbstractWriteTx newWriteOnlyTransaction() {
        this.checkOperationPermitted();
        DOMDataTreeWriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        if (!(writeTransaction instanceof AbstractWriteTx)) {
            throw new IllegalStateException("Unexpected transaction " + String.valueOf(writeTransaction));
        }
        AbstractWriteTx pendingWriteTx = (AbstractWriteTx)writeTransaction;
        this.pendingTransactions.put(pendingWriteTx, pendingWriteTx.addListener(this));
        this.currentTransaction = pendingWriteTx;
        return pendingWriteTx;
    }

    public final synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyChainListenerSuccess();
        }
    }

    @Override
    public final synchronized void onTransactionSuccessful(AbstractWriteTx transaction) {
        this.removePendingTx(transaction);
        this.notifyChainListenerSuccess();
    }

    @Override
    public final synchronized void onTransactionFailed(AbstractWriteTx transaction, Throwable cause) {
        this.removePendingTx(transaction);
        this.successful = false;
        if (this.currentTransaction != null) {
            this.currentTransaction.cancel();
        }
        this.future.setException(cause);
    }

    @Override
    public final synchronized void onTransactionSubmitted(AbstractWriteTx transaction) {
        this.currentTransaction = null;
    }

    @Override
    public final synchronized void onTransactionCancelled(AbstractWriteTx transaction) {
        this.removePendingTx(transaction);
        this.currentTransaction = null;
    }

    final void checkOperationPermitted() {
        if (this.closed) {
            throw new DOMTransactionChainClosedException("Transaction chain was closed");
        }
        Preconditions.checkState((this.currentTransaction == null ? 1 : 0) != 0, (Object)"Last write transaction has not finished yet");
    }

    private void removePendingTx(AbstractWriteTx transaction) {
        this.pendingTransactions.remove(transaction).close();
    }

    private void notifyChainListenerSuccess() {
        if (this.closed && this.pendingTransactions.isEmpty() && this.successful) {
            this.future.set((Object)Empty.value());
        }
    }
}

