/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.spi.TxListener;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MixinNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWriteTx
implements DOMDataTreeWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWriteTx.class);
    final RemoteDeviceId id;
    final NetconfBaseOps netOps;
    final boolean rollbackSupport;
    final List<ListenableFuture<? extends DOMRpcResult>> resultsFutures = new ArrayList<ListenableFuture<? extends DOMRpcResult>>();
    private final List<TxListener> listeners = new CopyOnWriteArrayList<TxListener>();
    private final SettableFuture<CommitInfo> resultFuture = SettableFuture.create();
    private final @NonNull FluentFuture<CommitInfo> completionFuture = FluentFuture.from(this.resultFuture);
    volatile boolean finished = false;
    final boolean isLockAllowed;

    AbstractWriteTx(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean isLockAllowed) {
        this.netOps = netconfOps;
        this.id = id;
        this.rollbackSupport = rollbackSupport;
        this.isLockAllowed = isLockAllowed;
    }

    final void checkNotFinished() {
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (String)"%s: Transaction %s already finished", (Object)this.id, (Object)this.getIdentifier());
    }

    final boolean isFinished() {
        return this.finished;
    }

    abstract void init();

    abstract void cleanup();

    public final FluentFuture<?> completionFuture() {
        return this.completionFuture;
    }

    public synchronized boolean cancel() {
        if (this.isFinished()) {
            return false;
        }
        this.listeners.forEach(listener -> listener.onTransactionCancelled(this));
        this.finished = true;
        this.cleanup();
        return true;
    }

    public final Object getIdentifier() {
        return this;
    }

    public final synchronized void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data) {
        this.checkEditable(store);
        if (AbstractWriteTx.containsOnlyNonVisibleData(path, data)) {
            LOG.debug("Ignoring put for {} and data {}. Resulting data structure is empty.", (Object)path, (Object)data);
            return;
        }
        ChoiceNode editStructure = this.netOps.createEditConfigStructure(Optional.ofNullable(data), Optional.of(EffectiveOperation.REPLACE), path);
        this.editConfig(path, Optional.ofNullable(data), (DataContainerChild)editStructure, Optional.empty(), "put");
    }

    public final synchronized void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data) {
        this.checkEditable(store);
        if (AbstractWriteTx.containsOnlyNonVisibleData(path, data)) {
            LOG.debug("Ignoring merge for {} and data {}. Resulting data structure is empty.", (Object)path, (Object)data);
            return;
        }
        ChoiceNode editStructure = this.netOps.createEditConfigStructure(Optional.ofNullable(data), Optional.empty(), path);
        this.editConfig(path, Optional.ofNullable(data), (DataContainerChild)editStructure, Optional.empty(), "merge");
    }

    private static boolean containsOnlyNonVisibleData(YangInstanceIdentifier path, NormalizedNode data) {
        return path.getPathArguments().size() == 1 && data instanceof MixinNode;
    }

    public final synchronized void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkEditable(store);
        ChoiceNode editStructure = this.netOps.createEditConfigStructure(Optional.empty(), Optional.of(EffectiveOperation.DELETE), path);
        this.editConfig(path, Optional.empty(), (DataContainerChild)editStructure, Optional.of(EffectiveOperation.NONE), "delete");
    }

    public FluentFuture<? extends CommitInfo> commit() {
        Futures.addCallback(this.commitConfiguration(), (FutureCallback)new FutureCallback<RpcResult<Void>>(){

            public void onSuccess(RpcResult<Void> result) {
                if (!result.isSuccessful()) {
                    AbstractWriteTx.this.resultFuture.setException((Throwable)new TransactionCommitFailedException(String.format("Commit of transaction %s failed", AbstractWriteTx.this.getIdentifier()), result.getErrors().toArray(new RpcError[0])));
                    return;
                }
                AbstractWriteTx.this.resultFuture.set((Object)CommitInfo.empty());
            }

            public void onFailure(Throwable failure) {
                AbstractWriteTx.this.resultFuture.setException((Throwable)new TransactionCommitFailedException(String.format("Commit of transaction %s failed", AbstractWriteTx.this.getIdentifier()), failure, new RpcError[0]));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return this.completionFuture;
    }

    final ListenableFuture<RpcResult<Void>> commitConfiguration() {
        this.listeners.forEach(listener -> listener.onTransactionSubmitted(this));
        this.checkNotFinished();
        this.finished = true;
        ListenableFuture<RpcResult<Void>> result = this.performCommit();
        Futures.addCallback(result, (FutureCallback)new FutureCallback<RpcResult<Void>>(){

            public void onSuccess(RpcResult<Void> rpcResult) {
                if (rpcResult.isSuccessful()) {
                    AbstractWriteTx.this.listeners.forEach(txListener -> txListener.onTransactionSuccessful(AbstractWriteTx.this));
                } else {
                    TransactionCommitFailedException cause = new TransactionCommitFailedException("Transaction failed", rpcResult.getErrors().toArray(new RpcError[rpcResult.getErrors().size()]));
                    AbstractWriteTx.this.listeners.forEach(listener -> listener.onTransactionFailed(AbstractWriteTx.this, (Throwable)cause));
                }
            }

            public void onFailure(Throwable throwable) {
                AbstractWriteTx.this.listeners.forEach(listener -> listener.onTransactionFailed(AbstractWriteTx.this, throwable));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    abstract ListenableFuture<RpcResult<Void>> performCommit();

    private void checkEditable(LogicalDatastoreType store) {
        this.checkNotFinished();
        Preconditions.checkArgument((store == LogicalDatastoreType.CONFIGURATION ? 1 : 0) != 0, (String)"Can edit only configuration data, not %s", (Object)store);
    }

    abstract void editConfig(YangInstanceIdentifier var1, Optional<NormalizedNode> var2, DataContainerChild var3, Optional<EffectiveOperation> var4, String var5);

    final ListenableFuture<RpcResult<Void>> resultsToTxStatus() {
        final SettableFuture transformed = SettableFuture.create();
        Futures.addCallback((ListenableFuture)Futures.allAsList(this.resultsFutures), (FutureCallback)new FutureCallback<List<DOMRpcResult>>(){

            public void onSuccess(List<DOMRpcResult> domRpcResults) {
                if (!transformed.isDone()) {
                    AbstractWriteTx.this.extractResult(domRpcResults, (SettableFuture<RpcResult<Void>>)transformed);
                }
            }

            public void onFailure(Throwable throwable) {
                NetconfDocumentedException exception = new NetconfDocumentedException(String.valueOf(AbstractWriteTx.this.id) + ":RPC during tx returned an exception" + throwable.getMessage(), new Exception(throwable), ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
                transformed.setException((Throwable)exception);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return transformed;
    }

    private void extractResult(List<DOMRpcResult> domRpcResults, SettableFuture<RpcResult<Void>> transformed) {
        ErrorType errType = ErrorType.APPLICATION;
        ErrorSeverity errSeverity = ErrorSeverity.ERROR;
        StringBuilder msgBuilder = new StringBuilder();
        boolean errorsEncouneterd = false;
        ErrorTag errorTag = ErrorTag.OPERATION_FAILED;
        for (DOMRpcResult domRpcResult : domRpcResults) {
            if (domRpcResult.errors().isEmpty()) continue;
            errorsEncouneterd = true;
            RpcError error = (RpcError)domRpcResult.errors().iterator().next();
            errType = error.getErrorType();
            errSeverity = error.getSeverity();
            msgBuilder.append(error.getMessage());
            msgBuilder.append(error.getInfo());
            errorTag = error.getTag();
        }
        if (errorsEncouneterd) {
            NetconfDocumentedException exception = new NetconfDocumentedException(String.valueOf(this.id) + ":RPC during tx failed. " + String.valueOf(msgBuilder), errType, errorTag, errSeverity);
            transformed.setException((Throwable)exception);
            return;
        }
        transformed.set((Object)RpcResultBuilder.success().build());
    }

    Registration addListener(final TxListener listener) {
        this.listeners.add(listener);
        return new AbstractRegistration(){

            protected void removeRegistration() {
                AbstractWriteTx.this.listeners.remove(listener);
            }
        };
    }
}

