/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.util.concurrent.FluentFuture;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcFutureCallback;
import org.opendaylight.netconf.client.mdsal.spi.AbstractReadOnlyTx;
import org.opendaylight.netconf.dom.api.tx.NetconfDOMFieldsReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FieldsAwareReadOnlyTx
extends AbstractReadOnlyTx
implements NetconfDOMFieldsReadTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(FieldsAwareReadOnlyTx.class);

    FieldsAwareReadOnlyTx(NetconfBaseOps netconfOps, RemoteDeviceId id) {
        super(netconfOps, id);
    }

    public FluentFuture<Optional<NormalizedNode>> read(LogicalDatastoreType store, YangInstanceIdentifier path, List<YangInstanceIdentifier> fields) {
        return switch (store) {
            case LogicalDatastoreType.CONFIGURATION -> this.readConfigurationData(path, fields);
            case LogicalDatastoreType.OPERATIONAL -> this.readOperationalData(path, fields);
            default -> {
                LOG.warn("Unknown datastore type: {}.", (Object)store);
                throw new IllegalArgumentException(String.format("%s, Cannot read data %s with fields %s for %s datastore, unknown datastore type", this.id, path, fields, store));
            }
        };
    }

    private @NonNull FluentFuture<Optional<NormalizedNode>> readConfigurationData(YangInstanceIdentifier path, List<YangInstanceIdentifier> fields) {
        return FieldsAwareReadOnlyTx.remapException(this.netconfOps.getConfigRunningData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path), fields));
    }

    private @NonNull FluentFuture<Optional<NormalizedNode>> readOperationalData(YangInstanceIdentifier path, List<YangInstanceIdentifier> fields) {
        return FieldsAwareReadOnlyTx.remapException(this.netconfOps.getData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path), fields));
    }
}

