/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.dom.DOMSource;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceSchema;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.api.SchemalessRpcService;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.GetConfig;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeepaliveSalFacade
implements RemoteDeviceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KeepaliveSalFacade.class);
    private static final long DEFAULT_DELAY = TimeUnit.MINUTES.toSeconds(2L);
    private static final long DEFAULT_TRANSACTION_TIMEOUT_MILLI = TimeUnit.MILLISECONDS.toMillis(60000L);
    private final RemoteDeviceHandler deviceHandler;
    private final RemoteDeviceId deviceId;
    private final NetconfTimer timer;
    private final long keepaliveDelaySeconds;
    private final long timeoutNanos;
    private final long delayNanos;
    private volatile NetconfDeviceCommunicator listener;
    private volatile KeepaliveTask task;

    public KeepaliveSalFacade(RemoteDeviceId deviceId, RemoteDeviceHandler deviceHandler, NetconfTimer timer, long keepaliveDelaySeconds, long requestTimeoutMillis) {
        this.deviceId = Objects.requireNonNull(deviceId);
        this.deviceHandler = Objects.requireNonNull(deviceHandler);
        this.timer = Objects.requireNonNull(timer);
        this.keepaliveDelaySeconds = keepaliveDelaySeconds;
        this.delayNanos = TimeUnit.SECONDS.toNanos(keepaliveDelaySeconds);
        this.timeoutNanos = TimeUnit.MILLISECONDS.toNanos(requestTimeoutMillis);
    }

    public KeepaliveSalFacade(RemoteDeviceId deviceId, RemoteDeviceHandler deviceHandler, NetconfTimer timer) {
        this(deviceId, deviceHandler, timer, DEFAULT_DELAY, DEFAULT_TRANSACTION_TIMEOUT_MILLI);
    }

    public void setListener(NetconfDeviceCommunicator listener) {
        this.listener = listener;
    }

    private synchronized void stopKeepalives() {
        KeepaliveTask localTask = this.task;
        if (localTask != null) {
            localTask.disableKeepalive();
            this.task = null;
        }
    }

    private void disableKeepalive() {
        KeepaliveTask localTask = this.task;
        if (localTask != null) {
            localTask.disableKeepalive();
        }
    }

    private void enableKeepalive() {
        KeepaliveTask localTask = this.task;
        if (localTask != null) {
            localTask.enableKeepalive();
        }
    }

    private void disconnect() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (String)"%s: Unable to reconnect, session listener is missing", (Object)this.deviceId);
        this.stopKeepalives();
        LOG.info("{}: Reconnecting inactive netconf session", (Object)this.deviceId);
        this.listener.disconnect();
    }

    @Override
    public void onDeviceConnected(NetconfDeviceSchema deviceSchema, NetconfSessionPreferences sessionPreferences, RemoteDeviceServices services) {
        RemoteDeviceServices.Rpcs keepaliveRpcs;
        RemoteDeviceServices.Rpcs devRpc = services.rpcs();
        this.task = new KeepaliveTask(devRpc);
        if (devRpc instanceof RemoteDeviceServices.Rpcs.Normalized) {
            RemoteDeviceServices.Rpcs.Normalized normalized = (RemoteDeviceServices.Rpcs.Normalized)devRpc;
            keepaliveRpcs = new NormalizedKeepaliveRpcs(normalized);
        } else if (devRpc instanceof RemoteDeviceServices.Rpcs.Schemaless) {
            RemoteDeviceServices.Rpcs.Schemaless schemaless = (RemoteDeviceServices.Rpcs.Schemaless)devRpc;
            keepaliveRpcs = new SchemalessKeepaliveRpcs(schemaless);
        } else {
            throw new IllegalStateException("Unhandled " + String.valueOf(devRpc));
        }
        this.deviceHandler.onDeviceConnected(deviceSchema, sessionPreferences, new RemoteDeviceServices(keepaliveRpcs, services.actions()));
        KeepaliveTask localTask = this.task;
        if (localTask != null) {
            LOG.debug("{}: Netconf session initiated, starting keepalives", (Object)this.deviceId);
            LOG.trace("{}: Scheduling keepalives every {}s", (Object)this.deviceId, (Object)this.keepaliveDelaySeconds);
            localTask.reschedule();
        }
    }

    @Override
    public void onDeviceDisconnected() {
        this.stopKeepalives();
        this.deviceHandler.onDeviceDisconnected();
    }

    @Override
    public void onDeviceFailed(Throwable throwable) {
        this.stopKeepalives();
        this.deviceHandler.onDeviceFailed(throwable);
    }

    @Override
    public void onNotification(DOMNotification domNotification) {
        KeepaliveTask localTask = this.task;
        if (localTask != null) {
            localTask.recordActivity();
        }
        this.deviceHandler.onNotification(domNotification);
    }

    @Override
    public void close() {
        this.stopKeepalives();
        this.deviceHandler.close();
    }

    private <T> @NonNull ListenableFuture<T> scheduleTimeout(ListenableFuture<T> invokeFuture) {
        RequestTimeoutTask<T> timeout = new RequestTimeoutTask<T>(invokeFuture);
        this.scheduleTimeout(invokeFuture, timeout);
        return timeout.userFuture;
    }

    private void scheduleTimeout(ListenableFuture<?> future, TimeoutTask timeoutTask) {
        Timeout timeout = this.timer.newTimeout((TimerTask)timeoutTask, this.timeoutNanos, TimeUnit.NANOSECONDS);
        future.addListener(() -> timeout.cancel(), MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    final class KeepaliveTask
    implements TimerTask,
    FutureCallback<DOMRpcResult> {
        static final @NonNull ContainerNode KEEPALIVE_PAYLOAD = NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, new DataContainerChild[]{NetconfBaseOps.getSourceNode(NetconfMessageTransformUtil.NETCONF_RUNNING_NODEID), NetconfMessageTransformUtil.EMPTY_FILTER});
        private final RemoteDeviceServices.Rpcs devRpc;
        private @GuardedBy(value={"this"}) boolean suppressed = false;
        private @GuardedBy(value={"this"}) int suppressedCounter = 0;
        private volatile long lastActivity;

        KeepaliveTask(RemoteDeviceServices.Rpcs devRpc) {
            this.devRpc = Objects.requireNonNull(devRpc);
        }

        public void run(Timeout timeout) {
            long local = this.lastActivity;
            long now = System.nanoTime();
            long inFutureNanos = local + KeepaliveSalFacade.this.delayNanos - now;
            if (inFutureNanos > 0L) {
                this.reschedule(inFutureNanos);
            } else {
                this.sendKeepalive(now);
            }
        }

        void recordActivity() {
            this.lastActivity = System.nanoTime();
        }

        synchronized void disableKeepalive() {
            this.suppressed = true;
            ++this.suppressedCounter;
        }

        synchronized void enableKeepalive() {
            this.recordActivity();
            --this.suppressedCounter;
            if (this.suppressedCounter > 0) {
                LOG.debug("{}: Skipping to enable keepalive while expecting {} RPC reply", (Object)KeepaliveSalFacade.this.deviceId, (Object)this.suppressedCounter);
                return;
            }
            if (this.suppressed) {
                this.suppressed = false;
            } else {
                this.reschedule();
            }
        }

        private synchronized void sendKeepalive(long now) {
            if (this.suppressed) {
                LOG.debug("{}: Skipping keepalive while disabled", (Object)KeepaliveSalFacade.this.deviceId);
                this.suppressed = false;
                return;
            }
            LOG.trace("{}: Invoking keepalive RPC", (Object)KeepaliveSalFacade.this.deviceId);
            ListenableFuture<? extends DOMRpcResult> deviceFuture = this.devRpc.invokeNetconf(GetConfig.QNAME, KEEPALIVE_PAYLOAD);
            this.lastActivity = now;
            KeepaliveSalFacade.this.scheduleTimeout(deviceFuture, new TimeoutTask(deviceFuture));
            Futures.addCallback(deviceFuture, (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
        }

        public void onSuccess(DOMRpcResult result) {
            if (result == null) {
                LOG.warn("{} Keepalive RPC returned null with response. Reconnecting netconf session", (Object)KeepaliveSalFacade.this.deviceId);
                KeepaliveSalFacade.this.disconnect();
                return;
            }
            if (result.value() != null) {
                this.reschedule();
            } else {
                Collection errors = result.errors();
                if (!errors.isEmpty()) {
                    LOG.warn("{}: Keepalive RPC failed with error: {}", (Object)KeepaliveSalFacade.this.deviceId, (Object)errors);
                    this.reschedule();
                } else {
                    LOG.warn("{} Keepalive RPC returned null with response. Reconnecting netconf session", (Object)KeepaliveSalFacade.this.deviceId);
                    KeepaliveSalFacade.this.disconnect();
                }
            }
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof CancellationException) {
                LOG.warn("{}: Keepalive RPC timed out. Reconnecting netconf session.", (Object)KeepaliveSalFacade.this.deviceId);
            } else {
                LOG.warn("{}: Keepalive RPC failed. Reconnecting netconf session.", (Object)KeepaliveSalFacade.this.deviceId, (Object)throwable);
            }
            KeepaliveSalFacade.this.disconnect();
        }

        private void reschedule() {
            this.reschedule(KeepaliveSalFacade.this.delayNanos);
        }

        private void reschedule(long delay) {
            KeepaliveSalFacade.this.timer.newTimeout((TimerTask)this, delay, TimeUnit.NANOSECONDS);
        }
    }

    private final class NormalizedKeepaliveRpcs
    implements RemoteDeviceServices.Rpcs.Normalized {
        private final @NonNull KeepaliveDOMRpcService domRpcService;
        private final RemoteDeviceServices.Rpcs.Normalized delegate;

        NormalizedKeepaliveRpcs(RemoteDeviceServices.Rpcs.Normalized delegate) {
            this.delegate = Objects.requireNonNull(delegate);
            this.domRpcService = new KeepaliveDOMRpcService(delegate.domRpcService());
        }

        @Override
        public ListenableFuture<? extends DOMRpcResult> invokeNetconf(QName type, ContainerNode input) {
            KeepaliveSalFacade.this.disableKeepalive();
            return KeepaliveSalFacade.this.scheduleTimeout(this.delegate.invokeNetconf(type, input));
        }

        @Override
        public DOMRpcService domRpcService() {
            return this.domRpcService;
        }
    }

    private final class SchemalessKeepaliveRpcs
    implements RemoteDeviceServices.Rpcs.Schemaless {
        private final @NonNull KeepaliveSchemalessRpcService schemalessRpcService;
        private final RemoteDeviceServices.Rpcs.Schemaless delegate;

        SchemalessKeepaliveRpcs(RemoteDeviceServices.Rpcs.Schemaless delegate) {
            this.delegate = Objects.requireNonNull(delegate);
            this.schemalessRpcService = new KeepaliveSchemalessRpcService(delegate.schemalessRpcService());
        }

        @Override
        public ListenableFuture<? extends DOMRpcResult> invokeNetconf(QName type, ContainerNode input) {
            KeepaliveSalFacade.this.disableKeepalive();
            return KeepaliveSalFacade.this.scheduleTimeout(this.delegate.invokeNetconf(type, input));
        }

        @Override
        public SchemalessRpcService schemalessRpcService() {
            return this.schemalessRpcService;
        }
    }

    private final class RequestTimeoutTask<V>
    extends TimeoutTask
    implements FutureCallback<V> {
        private final @NonNull SettableFuture<V> userFuture;

        RequestTimeoutTask(ListenableFuture<V> rpcResultFuture) {
            super(rpcResultFuture);
            this.userFuture = SettableFuture.create();
            Futures.addCallback(rpcResultFuture, (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
        }

        public void onSuccess(V result) {
            this.userFuture.set(result);
            KeepaliveSalFacade.this.enableKeepalive();
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof CancellationException) {
                LOG.warn("{}: RPC timed out. Reconnecting netconf session", (Object)KeepaliveSalFacade.this.deviceId);
            } else {
                LOG.warn("{}: RPC failed. Reconnecting netconf session", (Object)KeepaliveSalFacade.this.deviceId, (Object)throwable);
            }
            this.userFuture.setException(throwable);
            KeepaliveSalFacade.this.disconnect();
        }
    }

    private static class TimeoutTask
    implements TimerTask {
        private final ListenableFuture<?> future;

        TimeoutTask(ListenableFuture<?> future) {
            this.future = Objects.requireNonNull(future);
        }

        public final void run(Timeout timeout) {
            this.future.cancel(true);
        }
    }

    private final class KeepaliveSchemalessRpcService
    implements SchemalessRpcService {
        private final SchemalessRpcService delegate;

        KeepaliveSchemalessRpcService(SchemalessRpcService delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public ListenableFuture<? extends DOMSource> invokeRpc(QName type, DOMSource payload) {
            KeepaliveSalFacade.this.disableKeepalive();
            return KeepaliveSalFacade.this.scheduleTimeout(this.delegate.invokeRpc(type, payload));
        }
    }

    private final class KeepaliveDOMRpcService
    implements DOMRpcService {
        private final @NonNull DOMRpcService delegate;

        KeepaliveDOMRpcService(DOMRpcService delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public ListenableFuture<? extends DOMRpcResult> invokeRpc(QName type, ContainerNode input) {
            KeepaliveSalFacade.this.disableKeepalive();
            return KeepaliveSalFacade.this.scheduleTimeout(this.delegate.invokeRpc(type, input));
        }

        public Registration registerRpcListener(DOMRpcAvailabilityListener rpcListener) {
            return this.delegate.registerRpcListener(rpcListener);
        }
    }
}

