/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.collect.Collections2;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DefaultDOMRpcException;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.RpcTransformer;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

record NetconfDeviceDOMRpcService(EffectiveModelContext modelContext, RemoteDeviceCommunicator communicator, RpcTransformer<ContainerNode, DOMRpcResult> transformer) implements DOMRpcService
{
    NetconfDeviceDOMRpcService {
        Objects.requireNonNull(modelContext);
    }

    public ListenableFuture<DOMRpcResult> invokeRpc(final QName type, final ContainerNode input) {
        ListenableFuture<RpcResult<NetconfMessage>> delegateFuture = this.communicator.sendRequest(this.transformer.toRpcRequest(type, input));
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback(delegateFuture, (FutureCallback)new FutureCallback<RpcResult<NetconfMessage>>(){

            public void onSuccess(RpcResult<NetconfMessage> result) {
                DOMRpcResult rpcResult;
                try {
                    rpcResult = NetconfDeviceDOMRpcService.this.transformer.toRpcResult(result, type);
                }
                catch (Exception cause) {
                    ret.setException((Throwable)new DefaultDOMRpcException("Unable to parse rpc reply. type: " + String.valueOf(type) + " input: " + String.valueOf(input), (Throwable)cause));
                    return;
                }
                ret.set((Object)rpcResult);
            }

            public void onFailure(Throwable cause) {
                ret.setException((Throwable)new DOMRpcImplementationNotAvailableException(cause, "Unable to invoke rpc %s", new Object[]{type}));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ret;
    }

    public Registration registerRpcListener(DOMRpcAvailabilityListener listener) {
        listener.onRpcAvailable(Collections2.transform((Collection)this.modelContext.getOperations(), input -> DOMRpcIdentifier.create((QName)input.getQName())));
        return () -> {};
    }
}

