/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.spi.PingPongMergingDOMDataBroker;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.spi.AbstractWriteTx;
import org.opendaylight.netconf.client.mdsal.spi.FieldsAwareReadOnlyTx;
import org.opendaylight.netconf.client.mdsal.spi.FieldsAwareReadWriteTx;
import org.opendaylight.netconf.client.mdsal.spi.FieldsAwareTxChain;
import org.opendaylight.netconf.client.mdsal.spi.ReadOnlyTx;
import org.opendaylight.netconf.client.mdsal.spi.ReadWriteTx;
import org.opendaylight.netconf.client.mdsal.spi.TxChain;
import org.opendaylight.netconf.client.mdsal.spi.WriteCandidateRunningTx;
import org.opendaylight.netconf.client.mdsal.spi.WriteCandidateTx;
import org.opendaylight.netconf.client.mdsal.spi.WriteRunningTx;
import org.opendaylight.netconf.dom.api.tx.NetconfDOMDataBrokerFieldsExtension;
import org.opendaylight.netconf.dom.api.tx.NetconfDOMFieldsReadTransaction;
import org.opendaylight.netconf.dom.api.tx.NetconfDOMFieldsReadWriteTransaction;
import org.opendaylight.netconf.dom.api.tx.NetconfDOMFieldsTransactionChain;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;

public final class NetconfDeviceDataBroker
implements PingPongMergingDOMDataBroker {
    private final NetconfDOMDataBrokerFieldsExtension fieldsExtension = new NetconfDOMDataBrokerFieldsExtensionImpl();
    private final RemoteDeviceId id;
    private final NetconfBaseOps netconfOps;
    private final boolean rollbackSupport;
    private final boolean candidateSupported;
    private final boolean runningWritable;
    private final boolean lockDatastore;

    public NetconfDeviceDataBroker(RemoteDeviceId id, MountPointContext mountContext, RemoteDeviceServices.Rpcs rpcs, NetconfSessionPreferences netconfSessionPreferences, boolean lockDatastore) {
        this.id = id;
        this.netconfOps = new NetconfBaseOps(rpcs, mountContext);
        this.candidateSupported = netconfSessionPreferences.isCandidateSupported();
        this.runningWritable = netconfSessionPreferences.isRunningWritable();
        this.rollbackSupport = netconfSessionPreferences.isRollbackSupported();
        Preconditions.checkArgument((this.candidateSupported || this.runningWritable ? 1 : 0) != 0, (String)"Device %s has advertised neither :writable-running nor :candidate capability. At least one of these should be advertised. Failed to establish a session.", (Object)id.name());
        this.lockDatastore = lockDatastore;
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new ReadOnlyTx(this.netconfOps, this.id);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new ReadWriteTx<DOMDataTreeReadTransaction>(this.newReadOnlyTransaction(), this.newWriteOnlyTransaction());
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        AbstractWriteTx ret = this.candidateSupported ? (this.runningWritable ? new WriteCandidateRunningTx(this.id, this.netconfOps, this.rollbackSupport, this.lockDatastore) : new WriteCandidateTx(this.id, this.netconfOps, this.rollbackSupport, this.lockDatastore)) : new WriteRunningTx(this.id, this.netconfOps, this.rollbackSupport, this.lockDatastore);
        ((AbstractWriteTx)ret).init();
        return ret;
    }

    public DOMTransactionChain createTransactionChain() {
        return new TxChain((DOMDataBroker)this);
    }

    public List<DOMDataBroker.Extension> supportedExtensions() {
        return List.of(this.fieldsExtension);
    }

    private final class NetconfDOMDataBrokerFieldsExtensionImpl
    implements NetconfDOMDataBrokerFieldsExtension {
        private NetconfDOMDataBrokerFieldsExtensionImpl() {
        }

        public NetconfDOMFieldsReadTransaction newReadOnlyTransaction() {
            return new FieldsAwareReadOnlyTx(NetconfDeviceDataBroker.this.netconfOps, NetconfDeviceDataBroker.this.id);
        }

        public NetconfDOMFieldsReadWriteTransaction newReadWriteTransaction() {
            return new FieldsAwareReadWriteTx(this.newReadOnlyTransaction(), NetconfDeviceDataBroker.this.newWriteOnlyTransaction());
        }

        public NetconfDOMFieldsTransactionChain createTransactionChain() {
            return new FieldsAwareTxChain((DOMDataBroker)NetconfDeviceDataBroker.this, this);
        }
    }
}

