/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.spi.FixedDOMSchemaService;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.api.SchemalessRpcService;
import org.opendaylight.netconf.client.mdsal.spi.NetconfDeviceNotificationService;
import org.opendaylight.netconf.dom.api.NetconfDataTreeService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDeviceMount
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceMount.class);
    private final DOMMountPointService mountService;
    private final YangInstanceIdentifier mountPath;
    private final RemoteDeviceId id;
    private NetconfDeviceNotificationService notificationService;
    private ObjectRegistration<DOMMountPoint> topologyRegistration;

    public NetconfDeviceMount(RemoteDeviceId id, DOMMountPointService mountService, YangInstanceIdentifier mountPath) {
        this.id = Objects.requireNonNull(id);
        this.mountService = Objects.requireNonNull(mountService);
        this.mountPath = Objects.requireNonNull(mountPath);
    }

    public void onDeviceConnected(EffectiveModelContext initialCtx, RemoteDeviceServices services, DOMDataBroker broker, NetconfDataTreeService dataTreeService) {
        this.onDeviceConnected(initialCtx, services, new NetconfDeviceNotificationService(), broker, dataTreeService);
    }

    public synchronized void onDeviceConnected(EffectiveModelContext initialCtx, RemoteDeviceServices services, NetconfDeviceNotificationService newNotificationService, DOMDataBroker broker, NetconfDataTreeService dataTreeService) {
        Object normalized;
        Objects.requireNonNull(this.mountService, "Closed");
        Preconditions.checkState((this.topologyRegistration == null ? 1 : 0) != 0, (Object)"Already initialized");
        DOMMountPointService.DOMMountPointBuilder mountBuilder = this.mountService.createMountPoint(this.mountPath);
        mountBuilder.addService(DOMSchemaService.class, (DOMService)new FixedDOMSchemaService(initialCtx));
        RemoteDeviceServices.Rpcs rpcs = services.rpcs();
        mountBuilder.addService(NetconfRpcService.class, (DOMService)rpcs);
        if (rpcs instanceof RemoteDeviceServices.Rpcs.Normalized) {
            normalized = (RemoteDeviceServices.Rpcs.Normalized)rpcs;
            mountBuilder.addService(DOMRpcService.class, (DOMService)normalized.domRpcService());
        } else if (rpcs instanceof RemoteDeviceServices.Rpcs.Schemaless) {
            RemoteDeviceServices.Rpcs.Schemaless schemaless = (RemoteDeviceServices.Rpcs.Schemaless)rpcs;
            mountBuilder.addService(SchemalessRpcService.class, (DOMService)schemaless.schemalessRpcService());
        }
        RemoteDeviceServices.Actions actions = services.actions();
        if (actions instanceof RemoteDeviceServices.Actions.Normalized) {
            normalized = (RemoteDeviceServices.Actions.Normalized)actions;
            mountBuilder.addService(DOMActionService.class, (DOMService)normalized);
        }
        if (broker != null) {
            mountBuilder.addService(DOMDataBroker.class, (DOMService)broker);
        }
        if (dataTreeService != null) {
            mountBuilder.addService(NetconfDataTreeService.class, (DOMService)dataTreeService);
        }
        mountBuilder.addService(DOMNotificationService.class, (DOMService)newNotificationService);
        this.notificationService = newNotificationService;
        this.topologyRegistration = mountBuilder.register();
        LOG.debug("{}: Mountpoint exposed into MD-SAL {}", (Object)this.id, this.topologyRegistration);
    }

    public synchronized void onDeviceDisconnected() {
        if (this.topologyRegistration == null) {
            LOG.trace("{}: Not removing mountpoint from MD-SAL, mountpoint was not registered yet", (Object)this.id);
            return;
        }
        try {
            this.topologyRegistration.close();
        }
        finally {
            LOG.debug("{}: Mountpoint removed from MD-SAL {}", (Object)this.id, this.topologyRegistration);
            this.topologyRegistration = null;
        }
    }

    public synchronized void publish(DOMNotification domNotification) {
        ((NetconfDeviceNotificationService)Preconditions.checkNotNull((Object)this.notificationService, (String)"Device not set up yet, cannot handle notification %s", (Object)domNotification)).publishNotification(domNotification);
    }

    @Override
    public synchronized void close() {
        this.onDeviceDisconnected();
    }
}

