/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfDeviceNotificationService
implements DOMNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceNotificationService.class);
    private final Multimap<SchemaNodeIdentifier.Absolute, DOMNotificationListener> listeners = HashMultimap.create();

    public synchronized void publishNotification(DOMNotification notification) {
        for (DOMNotificationListener listener : this.listeners.get((Object)notification.getType())) {
            try {
                listener.onNotification(notification);
            }
            catch (Exception e) {
                LOG.warn("Listener {} threw an uncaught exception during processing notification {}", new Object[]{listener, notification, e});
            }
        }
    }

    public Registration registerNotificationListener(DOMNotificationListener listener, Collection<SchemaNodeIdentifier.Absolute> types) {
        DOMNotificationListener lsnr = Objects.requireNonNull(listener);
        SchemaNodeIdentifier.Absolute[] typesArray = (SchemaNodeIdentifier.Absolute[])types.stream().map(Objects::requireNonNull).distinct().toArray(SchemaNodeIdentifier.Absolute[]::new);
        return switch (typesArray.length) {
            case 0 -> () -> {};
            case 1 -> this.registerOne(lsnr, typesArray[0]);
            default -> this.registerMultiple(lsnr, typesArray);
        };
    }

    public Registration registerNotificationListener(DOMNotificationListener listener, SchemaNodeIdentifier.Absolute ... types) {
        return this.registerNotificationListener(listener, Arrays.asList(types));
    }

    public Registration registerNotificationListeners(Map<SchemaNodeIdentifier.Absolute, DOMNotificationListener> typeToListener) {
        Map<SchemaNodeIdentifier.Absolute, DOMNotificationListener> copy = Map.copyOf(typeToListener);
        return switch (copy.size()) {
            case 0 -> () -> {};
            case 1 -> {
                Map.Entry<SchemaNodeIdentifier.Absolute, DOMNotificationListener> entry = copy.entrySet().iterator().next();
                yield this.registerOne(entry.getValue(), entry.getKey());
            }
            default -> this.registerMultiple(copy);
        };
    }

    @VisibleForTesting
    synchronized int size() {
        return this.listeners.size();
    }

    private synchronized @NonNull Registration registerOne(final @NonNull DOMNotificationListener listener, final SchemaNodeIdentifier.Absolute type) {
        this.listeners.put((Object)type, (Object)listener);
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                NetconfDeviceNotificationService netconfDeviceNotificationService = NetconfDeviceNotificationService.this;
                synchronized (netconfDeviceNotificationService) {
                    NetconfDeviceNotificationService.this.listeners.remove((Object)type, (Object)listener);
                }
            }
        };
    }

    private synchronized @NonNull Registration registerMultiple(final @NonNull DOMNotificationListener listener, final SchemaNodeIdentifier.Absolute[] types) {
        for (SchemaNodeIdentifier.Absolute type : types) {
            this.listeners.put((Object)type, (Object)listener);
        }
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                NetconfDeviceNotificationService netconfDeviceNotificationService = NetconfDeviceNotificationService.this;
                synchronized (netconfDeviceNotificationService) {
                    for (SchemaNodeIdentifier.Absolute type : types) {
                        NetconfDeviceNotificationService.this.listeners.remove((Object)type, (Object)listener);
                    }
                }
            }
        };
    }

    private synchronized @NonNull Registration registerMultiple(Map<SchemaNodeIdentifier.Absolute, DOMNotificationListener> toReg) {
        int idx = 0;
        final Object[] array = new Object[toReg.size() * 2];
        for (Map.Entry<SchemaNodeIdentifier.Absolute, DOMNotificationListener> entry : toReg.entrySet()) {
            SchemaNodeIdentifier.Absolute type = entry.getKey();
            DOMNotificationListener listener = entry.getValue();
            this.listeners.put((Object)type, (Object)listener);
            array[idx++] = type;
            array[idx++] = listener;
        }
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                NetconfDeviceNotificationService netconfDeviceNotificationService = NetconfDeviceNotificationService.this;
                synchronized (netconfDeviceNotificationService) {
                    int i = 0;
                    int length = array.length;
                    while (i < length) {
                        Object listener;
                        Object type;
                        if (NetconfDeviceNotificationService.this.listeners.remove(type = array[i++], listener = array[i++])) continue;
                        LOG.warn("Failed to remove {} listener {}, very weird", new Object[]{type, listener, new Throwable()});
                    }
                }
            }
        };
    }
}

