/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceSchema;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.spi.AbstractNetconfDataTreeService;
import org.opendaylight.netconf.client.mdsal.spi.NetconfDeviceDataBroker;
import org.opendaylight.netconf.client.mdsal.spi.NetconfDeviceMount;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public class NetconfDeviceSalFacade
implements RemoteDeviceHandler,
AutoCloseable {
    private final RemoteDeviceId id;
    private final NetconfDeviceMount mount;
    private final boolean lockDatastore;

    public NetconfDeviceSalFacade(RemoteDeviceId id, DOMMountPointService mountPointService, YangInstanceIdentifier mountPath, boolean lockDatastore) {
        this(id, new NetconfDeviceMount(id, mountPointService, mountPath), lockDatastore);
    }

    @VisibleForTesting
    NetconfDeviceSalFacade(RemoteDeviceId id, NetconfDeviceMount mount, boolean lockDatastore) {
        this.id = Objects.requireNonNull(id);
        this.mount = Objects.requireNonNull(mount);
        this.lockDatastore = lockDatastore;
    }

    @Override
    public synchronized void onNotification(DOMNotification domNotification) {
        this.mount.publish(domNotification);
    }

    @Override
    public synchronized void onDeviceConnected(NetconfDeviceSchema deviceSchema, NetconfSessionPreferences sessionPreferences, RemoteDeviceServices services) {
        MountPointContext mountContext = deviceSchema.mountContext();
        EffectiveModelContext modelContext = mountContext.modelContext();
        RemoteDeviceServices.Rpcs deviceRpc = services.rpcs();
        AbstractNetconfDataTreeService netconfDataTree = AbstractNetconfDataTreeService.of(this.id, mountContext, deviceRpc, sessionPreferences, this.lockDatastore);
        NetconfDeviceDataBroker netconfDataBroker = new NetconfDeviceDataBroker(this.id, mountContext, deviceRpc, sessionPreferences, this.lockDatastore);
        this.mount.onDeviceConnected(modelContext, services, (DOMDataBroker)netconfDataBroker, netconfDataTree);
    }

    @Override
    public synchronized void onDeviceDisconnected() {
        this.mount.onDeviceDisconnected();
    }

    @Override
    public synchronized void onDeviceFailed(Throwable throwable) {
        this.mount.onDeviceDisconnected();
    }

    @Override
    public synchronized void close() {
        this.mount.close();
    }
}

