/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.api.RpcTransformer;
import org.opendaylight.netconf.client.mdsal.api.SchemalessRpcService;
import org.opendaylight.netconf.client.mdsal.impl.BaseRpcSchemalessTransformer;
import org.opendaylight.netconf.client.mdsal.impl.SchemalessMessageTransformer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

public final class SchemalessNetconfDeviceRpc
implements RemoteDeviceServices.Rpcs.Schemaless {
    private final @NonNull SchemalessRpcService schemalessRpcService;
    private final RemoteDeviceCommunicator listener;
    private final BaseRpcSchemalessTransformer baseRpcTransformer;
    private final SchemalessMessageTransformer schemalessTransformer;
    private final RemoteDeviceId deviceId;

    public SchemalessNetconfDeviceRpc(RemoteDeviceId deviceId, RemoteDeviceCommunicator listener, BaseRpcSchemalessTransformer baseRpcTransformer, SchemalessMessageTransformer messageTransformer) {
        this.deviceId = deviceId;
        this.listener = listener;
        this.baseRpcTransformer = baseRpcTransformer;
        this.schemalessTransformer = messageTransformer;
        this.schemalessRpcService = (type, input) -> this.handleRpc(type, input, this.schemalessTransformer);
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> invokeNetconf(QName type, ContainerNode input) {
        if (!SchemalessNetconfDeviceRpc.isBaseRpc(type)) {
            throw new IllegalArgumentException("Cannot handle " + String.valueOf(type));
        }
        return this.handleRpc(type, input, this.baseRpcTransformer);
    }

    @Override
    public SchemalessRpcService schemalessRpcService() {
        return this.schemalessRpcService;
    }

    private <I, R> @NonNull ListenableFuture<R> handleRpc(final @NonNull QName type, @NonNull I input, final RpcTransformer<I, R> transformer) {
        ListenableFuture<RpcResult<NetconfMessage>> delegateFuture = this.listener.sendRequest(transformer.toRpcRequest(type, input));
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback(delegateFuture, (FutureCallback)new FutureCallback<RpcResult<NetconfMessage>>(){

            public void onSuccess(RpcResult<NetconfMessage> result) {
                ret.set(transformer.toRpcResult(result, type));
            }

            public void onFailure(Throwable cause) {
                ret.setException((Throwable)new DOMRpcImplementationNotAvailableException(cause, "Unable to invoke rpc %s on device %s", new Object[]{type, SchemalessNetconfDeviceRpc.this.deviceId}));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ret;
    }

    private static boolean isBaseRpc(QName type) {
        return YangConstants.NETCONF_NAMESPACE.equals((Object)type.getNamespace());
    }
}

