/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcFutureCallback;
import org.opendaylight.netconf.client.mdsal.spi.WriteCandidateTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WriteCandidateRunningTx
extends WriteCandidateTx {
    private static final Logger LOG = LoggerFactory.getLogger(WriteCandidateRunningTx.class);

    WriteCandidateRunningTx(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean isLockAllowed) {
        super(id, netconfOps, rollbackSupport, isLockAllowed);
    }

    @Override
    synchronized void init() {
        this.lockRunning();
        super.init();
    }

    @Override
    void cleanupOnSuccess() {
        super.cleanupOnSuccess();
        this.unlockRunning();
    }

    private void lockRunning() {
        if (this.isLockAllowed) {
            this.resultsFutures.add(this.netOps.lockRunning(new NetconfRpcFutureCallback("Lock running", this.id)));
        } else {
            LOG.trace("Lock is not allowed: {}", (Object)this.id);
        }
    }

    private void unlockRunning() {
        if (this.isLockAllowed) {
            this.netOps.unlockRunning(new NetconfRpcFutureCallback("Unlock running", this.id));
        } else {
            LOG.trace("Unlock is not allowed: {}", (Object)this.id);
        }
    }
}

