/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcFutureCallback;
import org.opendaylight.netconf.client.mdsal.spi.AbstractWriteTx;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteCandidateTx
extends AbstractWriteTx {
    private static final Logger LOG = LoggerFactory.getLogger(WriteCandidateTx.class);

    WriteCandidateTx(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean isLockAllowed) {
        super(id, netconfOps, rollbackSupport, isLockAllowed);
    }

    @Override
    synchronized void init() {
        LOG.trace("{}: Initializing {} transaction", (Object)this.id, (Object)this.getClass().getSimpleName());
        this.lock();
    }

    private void lock() {
        if (!this.isLockAllowed) {
            LOG.trace("Lock is not allowed.");
            return;
        }
        FutureCallback<DOMRpcResult> lockCandidateCallback = new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult result) {
                if (result.errors().isEmpty()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Lock candidate successful");
                    }
                } else {
                    LOG.warn("{}: lock candidate invoked unsuccessfully: {}", (Object)WriteCandidateTx.this.id, (Object)result.errors());
                }
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Lock candidate operation failed", throwable);
                WriteCandidateTx.this.discardChanges();
            }
        };
        this.resultsFutures.add(this.netOps.lockCandidate(lockCandidateCallback));
    }

    @Override
    void cleanup() {
        this.discardChanges();
        this.cleanupOnSuccess();
    }

    private void discardChanges() {
        this.netOps.discardChanges(new NetconfRpcFutureCallback("Discarding candidate", this.id));
    }

    @Override
    public synchronized ListenableFuture<RpcResult<Void>> performCommit() {
        this.resultsFutures.add(this.netOps.commit(new NetconfRpcFutureCallback("Commit", this.id)));
        ListenableFuture<RpcResult<Void>> txResult = this.resultsToTxStatus();
        Futures.addCallback(txResult, (FutureCallback)new FutureCallback<RpcResult<Void>>(){

            public void onSuccess(RpcResult<Void> result) {
                WriteCandidateTx.this.cleanupOnSuccess();
            }

            public void onFailure(Throwable throwable) {
                WriteCandidateTx.this.cleanup();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return txResult;
    }

    void cleanupOnSuccess() {
        this.unlock();
    }

    @Override
    protected void editConfig(YangInstanceIdentifier path, Optional<NormalizedNode> data, DataContainerChild editStructure, Optional<EffectiveOperation> defaultOperation, String operation) {
        NetconfRpcFutureCallback editConfigCallback = new NetconfRpcFutureCallback("Edit candidate", this.id);
        if (defaultOperation.isPresent()) {
            this.resultsFutures.add(this.netOps.editConfigCandidate(editConfigCallback, editStructure, defaultOperation.orElseThrow(), this.rollbackSupport));
        } else {
            this.resultsFutures.add(this.netOps.editConfigCandidate(editConfigCallback, editStructure, this.rollbackSupport));
        }
    }

    private void unlock() {
        if (this.isLockAllowed) {
            this.netOps.unlockCandidate(new NetconfRpcFutureCallback("Unlock candidate", this.id));
        } else {
            LOG.trace("Unlock is not allowed: {}", (Object)this.id);
        }
    }
}

