/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.spi;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfBaseOps;
import org.opendaylight.netconf.client.mdsal.impl.NetconfRpcFutureCallback;
import org.opendaylight.netconf.client.mdsal.spi.AbstractWriteTx;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WriteRunningTx
extends AbstractWriteTx {
    private static final Logger LOG = LoggerFactory.getLogger(WriteRunningTx.class);
    private final List<Change> changes = new ArrayList<Change>();

    WriteRunningTx(RemoteDeviceId id, NetconfBaseOps netconfOps, boolean rollbackSupport, boolean isLockAllowed) {
        super(id, netconfOps, rollbackSupport, isLockAllowed);
    }

    @Override
    synchronized void init() {
        this.lock();
    }

    private void lock() {
        if (this.isLockAllowed) {
            this.resultsFutures.add(this.netOps.lockRunning(new NetconfRpcFutureCallback("Lock running", this.id)));
        } else {
            LOG.trace("Lock is not allowed: {}", (Object)this.id);
        }
    }

    @Override
    void cleanup() {
        this.unlock();
    }

    @Override
    public synchronized ListenableFuture<RpcResult<Void>> performCommit() {
        for (Change change : this.changes) {
            this.resultsFutures.add(change.execute(this.id, this.netOps, this.rollbackSupport));
        }
        this.unlock();
        return this.resultsToTxStatus();
    }

    @Override
    protected void editConfig(YangInstanceIdentifier path, Optional<NormalizedNode> data, DataContainerChild editStructure, Optional<EffectiveOperation> defaultOperation, String operation) {
        this.changes.add(new Change(editStructure, defaultOperation));
    }

    private void unlock() {
        if (this.isLockAllowed) {
            this.netOps.unlockRunning(new NetconfRpcFutureCallback("Unlock running", this.id));
        } else {
            LOG.trace("Unlock is not allowed: {}", (Object)this.id);
        }
    }

    private static final class Change {
        private final DataContainerChild editStructure;
        private final Optional<EffectiveOperation> defaultOperation;

        Change(DataContainerChild editStructure, Optional<EffectiveOperation> defaultOperation) {
            this.editStructure = editStructure;
            this.defaultOperation = defaultOperation;
        }

        ListenableFuture<? extends DOMRpcResult> execute(RemoteDeviceId id, NetconfBaseOps netOps, boolean rollbackSupport) {
            NetconfRpcFutureCallback editConfigCallback = new NetconfRpcFutureCallback("Edit running", id);
            if (this.defaultOperation.isPresent()) {
                return netOps.editConfigRunning(editConfigCallback, this.editStructure, this.defaultOperation.orElseThrow(), rollbackSupport);
            }
            return netOps.editConfigRunning(editConfigCallback, this.editStructure, rollbackSupport);
        }
    }
}

