/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.protocol.Specification;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;

public class ProtocolBuilder {
    private Set<String> _keyId;
    private Protocol.Name _name;
    private Specification _specification;
    Map<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>> augmentation = Map.of();

    public ProtocolBuilder() {
    }

    public ProtocolBuilder(Protocol base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>>(aug);
        }
        this._keyId = base.getKeyId();
        this._name = base.getName();
        this._specification = base.getSpecification();
    }

    public static @NonNull Protocol empty() {
        return LazyEmpty.INSTANCE;
    }

    public Set<String> getKeyId() {
        return this._keyId;
    }

    public Protocol.Name getName() {
        return this._name;
    }

    public Specification getSpecification() {
        return this._specification;
    }

    public <E$$ extends Augmentation<Protocol>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ProtocolBuilder setKeyId(Set<String> values) {
        this._keyId = values;
        return this;
    }

    public ProtocolBuilder setName(Protocol.Name value) {
        this._name = value;
        return this;
    }

    public ProtocolBuilder setSpecification(Specification value) {
        this._specification = value;
        return this;
    }

    public ProtocolBuilder addAugmentation(Augmentation<Protocol> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ProtocolBuilder removeAugmentation(Class<? extends Augmentation<Protocol>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Protocol build() {
        return new ProtocolImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Protocol INSTANCE = new ProtocolBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ProtocolImpl
    extends AbstractAugmentable<Protocol>
    implements Protocol {
        private final Set<String> _keyId;
        private final Protocol.Name _name;
        private final Specification _specification;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ProtocolImpl(ProtocolBuilder base) {
            super(base.augmentation);
            this._keyId = base.getKeyId();
            this._name = base.getName();
            this._specification = base.getSpecification();
        }

        @Override
        public Set<String> getKeyId() {
            return this._keyId;
        }

        @Override
        public Protocol.Name getName() {
            return this._name;
        }

        @Override
        public Specification getSpecification() {
            return this._specification;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Protocol.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Protocol.bindingEquals(this, obj);
        }

        public String toString() {
            return Protocol.bindingToString(this);
        }
    }
}

