/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import java.io.IOException;
import java.io.Writer;

public final class BufferedWriter
extends Writer {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private final Writer writer;
    private final char[] buffer;
    private final int bufferSize;
    private int nextChar = 0;

    public BufferedWriter(Writer writer) {
        this(writer, 8192);
    }

    public BufferedWriter(Writer writer, int bufferSize) {
        super((Object)writer);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.writer = writer;
        this.bufferSize = bufferSize;
        this.buffer = new char[bufferSize];
    }

    private void flushBuffer() throws IOException {
        if (this.nextChar == 0) {
            return;
        }
        this.writer.write(this.buffer, 0, this.nextChar);
        this.nextChar = 0;
    }

    @Override
    public void write(int character) throws IOException {
        if (this.nextChar >= this.bufferSize) {
            this.flushBuffer();
        }
        this.buffer[this.nextChar++] = (char)character;
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException("Buffer size: %d, Offset: %d, Length: %d".formatted(buffer.length, offset, length));
        }
        if (length == 0) {
            return;
        }
        if (length >= this.bufferSize) {
            this.flushBuffer();
            this.writer.write(buffer, offset, length);
            return;
        }
        int bufferOffset = offset;
        int t = offset + length;
        while (bufferOffset < t) {
            int d = Math.min(this.bufferSize - this.nextChar, t - bufferOffset);
            System.arraycopy(buffer, bufferOffset, this.buffer, this.nextChar, d);
            bufferOffset += d;
            this.nextChar += d;
            if (this.nextChar < this.bufferSize) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void write(String string, int offset, int length) throws IOException {
        int bufferOffset = offset;
        int t = offset + length;
        while (bufferOffset < t) {
            int d = Math.min(this.bufferSize - this.nextChar, t - bufferOffset);
            string.getChars(bufferOffset, bufferOffset + d, this.buffer, this.nextChar);
            bufferOffset += d;
            this.nextChar += d;
            if (this.nextChar < this.bufferSize) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushBuffer();
        }
        finally {
            this.writer.close();
        }
    }
}

