/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.MessageWriter;
import org.opendaylight.netconf.codec.XMLMessageWriter;

@Deprecated(since="8.0.1", forRemoval=true)
public final class HelloMessageWriter
extends MessageWriter {
    private static final HelloMessageWriter DEFAULT = new HelloMessageWriter(false);
    private static final HelloMessageWriter PRETTY = new HelloMessageWriter(true);
    private final XMLMessageWriter delegate;

    private HelloMessageWriter(boolean pretty) {
        super(pretty);
        this.delegate = XMLMessageWriter.of(pretty);
    }

    public static HelloMessageWriter of() {
        return DEFAULT;
    }

    public static HelloMessageWriter of(boolean pretty) {
        return pretty ? PRETTY : DEFAULT;
    }

    public static HelloMessageWriter pretty() {
        return PRETTY;
    }

    @Override
    protected void writeTo(NetconfMessage message, OutputStream out) throws IOException, TransformerException {
        if (!(message instanceof HelloMessage)) {
            throw new IllegalStateException("Netconf message of type %s expected, was %s".formatted(HelloMessage.class, message.getClass()));
        }
        HelloMessage hello = (HelloMessage)message;
        Optional header = hello.getAdditionalHeader();
        if (header.isPresent()) {
            out.write(((NetconfHelloMessageAdditionalHeader)header.orElseThrow()).toFormattedString().getBytes(StandardCharsets.UTF_8));
        }
        this.delegate.writeTo(message, out);
    }
}

