/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.VerifyException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.FramingSupport;
import org.opendaylight.netconf.codec.MessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageEncoder
extends MessageToByteEncoder<NetconfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageEncoder.class);
    private @NonNull FramingSupport framing = FramingSupport.eom();
    private @NonNull MessageWriter writer;
    private @Nullable MessageWriter nextWriter;

    public MessageEncoder(MessageWriter writer) {
        super(NetconfMessage.class);
        this.writer = Objects.requireNonNull(writer);
    }

    public void setFraming(FramingSupport newFraming) {
        this.framing = Objects.requireNonNull(newFraming);
        LOG.debug("Switched framing to {}", (Object)this.framing);
    }

    public void setWriter(MessageWriter newWriter) {
        this.doSetWriter(Objects.requireNonNull(newWriter));
    }

    private void doSetWriter(@NonNull MessageWriter newWriter) {
        this.writer = newWriter;
        LOG.debug("Switched writer to {}", (Object)this.writer);
    }

    public void setNextWriter(MessageWriter newNextWriter) {
        MessageWriter local = this.nextWriter;
        if (local != null) {
            throw new VerifyException("Next writer already set to " + String.valueOf(local));
        }
        this.nextWriter = Objects.requireNonNull(newNextWriter);
        LOG.debug("Switching to {} after next message", (Object)this.nextWriter);
    }

    @VisibleForTesting
    public @NonNull FramingSupport framing() {
        return this.framing;
    }

    @VisibleForTesting
    public @NonNull MessageWriter writer() {
        return this.writer;
    }

    @VisibleForTesting
    public @Nullable MessageWriter nextWriter() {
        return this.nextWriter;
    }

    protected void encode(ChannelHandlerContext ctx, NetconfMessage msg, ByteBuf out) throws Exception {
        LOG.trace("Sent to encode : {}", (Object)msg);
        this.framing.writeMessage(ctx.alloc(), msg, this.writer, out);
        MessageWriter local = this.nextWriter;
        if (local != null) {
            this.nextWriter = null;
            this.doSetWriter(local);
        }
    }
}

