/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.codec.MessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLMessageDecoder
extends MessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(XMLMessageDecoder.class);

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException, SAXException {
        if (in.isReadable()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
            }
            while (in.isReadable()) {
                if (XMLMessageDecoder.isWhitespace(in.readByte())) continue;
                in.readerIndex(in.readerIndex() - 1);
                break;
            }
            if (in.readerIndex() != 0 && LOG.isWarnEnabled()) {
                byte[] strippedBytes = new byte[in.readerIndex()];
                in.getBytes(0, strippedBytes, 0, in.readerIndex());
                LOG.warn("XML message with unwanted leading bytes detected. Discarded the {} leading byte(s): '{}'", (Object)in.readerIndex(), (Object)ByteBufUtil.hexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])strippedBytes)));
            }
        }
        if (in.isReadable()) {
            try {
                out.add(new NetconfMessage(XmlUtil.readXmlToDocument((InputStream)new ByteBufInputStream(in))));
            }
            catch (SAXParseException e) {
                LOG.error("Failed to parse received message", (Throwable)e);
                out.add(e);
                in.skipBytes(in.readableBytes());
            }
        } else {
            LOG.debug("No more content in incoming buffer.");
        }
    }

    private static boolean isWhitespace(byte byteToCheck) {
        return byteToCheck <= 13 && byteToCheck >= 9 || byteToCheck == 32;
    }
}

