/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.BufferedWriter;
import org.opendaylight.netconf.codec.MessageWriter;

@NonNullByDefault
public final class XMLMessageWriter
extends MessageWriter {
    private static final XMLMessageWriter DEFAULT = new XMLMessageWriter(false);
    private static final XMLMessageWriter PRETTY = new XMLMessageWriter(true);

    private XMLMessageWriter(boolean pretty) {
        super(pretty);
    }

    public static XMLMessageWriter of() {
        return DEFAULT;
    }

    public static XMLMessageWriter of(boolean pretty) {
        return pretty ? PRETTY : DEFAULT;
    }

    public static XMLMessageWriter pretty() {
        return PRETTY;
    }

    @Override
    protected void writeTo(NetconfMessage message, OutputStream out) throws IOException, TransformerException {
        StreamResult result = new StreamResult(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
        DOMSource source = new DOMSource(message.getDocument());
        this.threadLocalTransformer().transform(source, result);
    }
}

