/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.mdsal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.opendaylight.yangtools.concepts.Immutable;

final class AnyXmlNamespaceContext
implements Immutable,
NamespaceContext {
    private static final ImmutableBiMap<String, String> FIXED_PREFIX_TO_URI = ImmutableBiMap.of((Object)"xml", (Object)"http://www.w3.org/XML/1998/namespace", (Object)"xmlns", (Object)"http://www.w3.org/2000/xmlns/");
    private final ImmutableListMultimap<String, String> uriToPrefix;
    private final ImmutableBiMap<String, String> prefixToUri;

    AnyXmlNamespaceContext(Map<String, String> prefixToUri) {
        ImmutableListMultimap.Builder uriToPrefixBuilder = ImmutableListMultimap.builder();
        HashBiMap prefixToUriBuilder = HashBiMap.create();
        prefixToUriBuilder.putAll(FIXED_PREFIX_TO_URI);
        uriToPrefixBuilder.putAll((Iterable)FIXED_PREFIX_TO_URI.inverse().entrySet());
        String defaultURI = prefixToUri.get("");
        if (defaultURI != null) {
            AnyXmlNamespaceContext.checkMapping("", defaultURI);
            uriToPrefixBuilder.put((Object)defaultURI, (Object)"");
            prefixToUriBuilder.putIfAbsent((Object)"", (Object)defaultURI);
        }
        for (Map.Entry<String, String> entry : prefixToUri.entrySet()) {
            String prefix = Objects.requireNonNull(entry.getKey());
            if (prefix.isEmpty()) continue;
            String namespaceURI = Objects.requireNonNull(entry.getValue());
            AnyXmlNamespaceContext.checkMapping(prefix, namespaceURI);
            uriToPrefixBuilder.put((Object)namespaceURI, (Object)prefix);
            prefixToUriBuilder.putIfAbsent((Object)prefix, (Object)namespaceURI);
        }
        this.uriToPrefix = uriToPrefixBuilder.build();
        this.prefixToUri = ImmutableBiMap.copyOf((Map)prefixToUriBuilder);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return AnyXmlNamespaceContext.getValue(this.prefixToUri, prefix, "");
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return AnyXmlNamespaceContext.getValue((ImmutableBiMap<String, String>)this.prefixToUri.inverse(), namespaceURI, null);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0);
        return this.uriToPrefix.get((Object)namespaceURI).iterator();
    }

    Collection<Map.Entry<String, String>> uriPrefixEntries() {
        return this.uriToPrefix.entries();
    }

    private static void checkMapping(String prefix, String namespaceURI) {
        Preconditions.checkArgument((!namespaceURI.isEmpty() ? 1 : 0) != 0, (String)"Namespace must not be empty (%s)", (Object)prefix);
        Preconditions.checkArgument((!FIXED_PREFIX_TO_URI.containsKey((Object)prefix) ? 1 : 0) != 0, (String)"Cannot bind prefix %s", (Object)prefix);
        Preconditions.checkArgument((!FIXED_PREFIX_TO_URI.containsValue((Object)namespaceURI) ? 1 : 0) != 0, (String)"Cannot bind namespace %s", (Object)namespaceURI);
    }

    private static String getValue(ImmutableBiMap<String, String> map, String key, String defaultValue) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        String found = (String)map.get((Object)key);
        return found == null ? defaultValue : found;
    }
}

