/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.mdsal;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.common.mdsal.EmptyListXmlWriter;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;

final class EmptyListXmlMetadataWriter
extends ForwardingNormalizedNodeStreamWriter {
    private final Deque<NormalizedMetadata> stack = new ArrayDeque<NormalizedMetadata>();
    private final EmptyListXmlWriter dataWriterDelegate;
    private final NormalizedNodeStreamWriter.MetadataExtension metaWriter;
    private final NormalizedMetadata metadata;
    private int absentDepth = 0;

    EmptyListXmlMetadataWriter(@NonNull NormalizedNodeStreamWriter writer, @NonNull XMLStreamWriter xmlStreamWriter, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull NormalizedNodeStreamWriter.MetadataExtension metaWriter, @NonNull NormalizedMetadata metadata) {
        this.dataWriterDelegate = new EmptyListXmlWriter(Objects.requireNonNull(writer), Objects.requireNonNull(xmlStreamWriter));
        this.metaWriter = Objects.requireNonNull(metaWriter);
        this.metadata = Objects.requireNonNull(metadata);
    }

    protected NormalizedNodeStreamWriter delegate() {
        return this.dataWriterDelegate.delegate();
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.dataWriterDelegate.startLeafNode(name);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startLeafSet(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startOrderedLeafSet(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.dataWriterDelegate.startLeafSetEntryNode(name);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startContainerNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startUnkeyedList(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startUnkeyedListItem(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startMapNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startMapEntryNode(identifier, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)identifier);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startOrderedMapNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.dataWriterDelegate.startChoiceNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        boolean ret = this.dataWriterDelegate.startAnyxmlNode(name, objectModel);
        if (ret) {
            this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
        }
        return ret;
    }

    public void endNode() throws IOException {
        this.dataWriterDelegate.endNode();
        if (this.absentDepth > 0) {
            --this.absentDepth;
        } else {
            this.stack.pop();
        }
    }

    private void enterMetadataNode(YangInstanceIdentifier.PathArgument name) throws IOException {
        if (this.absentDepth > 0) {
            ++this.absentDepth;
            return;
        }
        NormalizedMetadata current = this.stack.peek();
        if (current != null) {
            NormalizedMetadata child = (NormalizedMetadata)current.getChildren().get(name);
            if (child != null) {
                this.enterChild(child);
            } else {
                this.absentDepth = 1;
            }
        } else {
            this.enterChild(this.metadata);
        }
    }

    private void enterChild(NormalizedMetadata child) throws IOException {
        Map annotations = child.getAnnotations();
        if (!annotations.isEmpty()) {
            this.metaWriter.metadata(ImmutableMap.copyOf((Map)annotations));
        }
        this.stack.push(child);
    }
}

