/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.mdsal;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;

final class EmptyListXmlWriter
extends ForwardingNormalizedNodeStreamWriter {
    private final NormalizedNodeStreamWriter delegatedWriter;
    private final XMLStreamWriter xmlStreamWriter;
    private boolean isInsideEmptyList = false;

    EmptyListXmlWriter(NormalizedNodeStreamWriter delegatedWriter, XMLStreamWriter xmlStreamWriter) {
        this.delegatedWriter = delegatedWriter;
        this.xmlStreamWriter = xmlStreamWriter;
    }

    protected NormalizedNodeStreamWriter delegate() {
        return this.delegatedWriter;
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        if (childSizeHint == 0) {
            this.writeEmptyElement(name);
        } else {
            super.startUnkeyedList(name, childSizeHint);
        }
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        if (childSizeHint == 0) {
            this.writeEmptyElement(name);
        } else {
            super.startMapNode(name, childSizeHint);
        }
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        if (childSizeHint == 0) {
            this.writeEmptyElement(name);
        } else {
            super.startOrderedMapNode(name, childSizeHint);
        }
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        if (childSizeHint == 0) {
            this.writeEmptyElement(name);
        } else {
            super.startLeafSet(name, childSizeHint);
        }
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        if (childSizeHint == 0) {
            this.writeEmptyElement(name);
        } else {
            super.startOrderedLeafSet(name, childSizeHint);
        }
    }

    public void endNode() throws IOException {
        if (this.isInsideEmptyList) {
            this.isInsideEmptyList = false;
        } else {
            super.endNode();
        }
    }

    private void writeEmptyElement(YangInstanceIdentifier.NodeIdentifier identifier) throws IOException {
        QName nodeType = identifier.getNodeType();
        try {
            this.xmlStreamWriter.writeEmptyElement("", nodeType.getLocalName(), nodeType.getNamespace().toString());
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to serialize empty element to XML: " + String.valueOf(identifier), e);
        }
        this.isInsideEmptyList = true;
    }
}

