/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.mdsal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.common.mdsal.AnyXmlNamespaceContext;
import org.opendaylight.netconf.common.mdsal.EmptyListXmlMetadataWriter;
import org.opendaylight.netconf.common.mdsal.EmptyListXmlWriter;
import org.opendaylight.netconf.common.mdsal.PathNode;
import org.opendaylight.netconf.common.mdsal.ProxyMountPointContext;
import org.opendaylight.netconf.common.mdsal.StreamingContext;
import org.opendaylight.yangtools.concepts.AbstractHierarchicalIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedMetadataWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class NormalizedDataUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedDataUtil.class);
    public static final XMLOutputFactory XML_FACTORY;
    private static final NamespaceSetter XML_NAMESPACE_SETTER;

    private NormalizedDataUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedNode(NormalizedNode normalized, DOMResult result, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path) throws IOException, XMLStreamException {
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path);
             NormalizedNodeWriter writer = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);){
            writer.write(normalized);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedNode(NormalizedNode normalized, @Nullable NormalizedMetadata metadata, DOMResult result, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path) throws IOException, XMLStreamException {
        if (metadata == null) {
            NormalizedDataUtil.writeNormalizedNode(normalized, result, context, path);
            return;
        }
        XML_NAMESPACE_SETTER.initializeNamespace(xmlWriter);
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path);
             NormalizedMetadataWriter writer = NormalizedMetadataWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);){
            writer.write(normalized, metadata);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedNode(YangInstanceIdentifier query, DOMResult result, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path) throws IOException, XMLStreamException {
        XML_NAMESPACE_SETTER.initializeNamespace(xmlWriter);
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path);
             EmptyListXmlWriter writer = new EmptyListXmlWriter(streamWriter, xmlWriter);){
            Iterator<YangInstanceIdentifier.PathArgument> it = query.getPathArguments().iterator();
            YangInstanceIdentifier.PathArgument first = (YangInstanceIdentifier.PathArgument)it.next();
            StreamingContext.fromSchemaAndQNameChecked((DataNodeContainer)context, first.getNodeType()).streamToWriter((NormalizedNodeStreamWriter)writer, first, it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedNode(YangInstanceIdentifier query, @Nullable NormalizedMetadata metadata, DOMResult result, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path) throws IOException, XMLStreamException {
        if (metadata == null) {
            NormalizedDataUtil.writeNormalizedNode(query, result, context, path);
            return;
        }
        XML_NAMESPACE_SETTER.initializeNamespace(xmlWriter);
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path);
             EmptyListXmlMetadataWriter writer = new EmptyListXmlMetadataWriter(streamWriter, xmlWriter, (NormalizedNodeStreamWriter.MetadataExtension)streamWriter.extension(NormalizedNodeStreamWriter.MetadataExtension.class), metadata);){
            Iterator<YangInstanceIdentifier.PathArgument> it = query.getPathArguments().iterator();
            YangInstanceIdentifier.PathArgument first = (YangInstanceIdentifier.PathArgument)it.next();
            StreamingContext.fromSchemaAndQNameChecked((DataNodeContainer)context, first.getNodeType()).streamToWriter((NormalizedNodeStreamWriter)writer, first, it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFilter(YangInstanceIdentifier query, DOMResult result, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path) throws IOException, XMLStreamException {
        if (query.isEmpty()) {
            return;
        }
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path);
             EmptyListXmlWriter writer = new EmptyListXmlWriter(streamWriter, xmlWriter);){
            Iterator<YangInstanceIdentifier.PathArgument> it = query.getPathArguments().iterator();
            YangInstanceIdentifier.PathArgument first = (YangInstanceIdentifier.PathArgument)it.next();
            StreamingContext.fromSchemaAndQNameChecked((DataNodeContainer)context, first.getNodeType()).streamToWriter((NormalizedNodeStreamWriter)writer, first, it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFilter(YangInstanceIdentifier query, DOMResult result, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path, List<YangInstanceIdentifier> fields) throws IOException, XMLStreamException {
        if (query.isEmpty() || fields.isEmpty()) {
            return;
        }
        List<YangInstanceIdentifier> aggregatedFields = NormalizedDataUtil.aggregateFields(fields);
        PathNode rootNode = NormalizedDataUtil.constructPathArgumentTree(query, aggregatedFields);
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path);
             EmptyListXmlWriter writer = new EmptyListXmlWriter(streamWriter, xmlWriter);){
            YangInstanceIdentifier.PathArgument first = rootNode.element();
            StreamingContext.fromSchemaAndQNameChecked((DataNodeContainer)context, first.getNodeType()).streamToWriter((NormalizedNodeStreamWriter)writer, first, rootNode);
        }
    }

    public static void writeSchemalessFilter(YangInstanceIdentifier query, List<YangInstanceIdentifier> fields, Element filterElement) {
        NormalizedDataUtil.pathArgumentTreeToXmlStructure(NormalizedDataUtil.constructPathArgumentTree(query, NormalizedDataUtil.aggregateFields(fields)), filterElement);
    }

    private static void pathArgumentTreeToXmlStructure(PathNode pathArgumentTree, Element data) {
        YangInstanceIdentifier.PathArgument pathArg = pathArgumentTree.element();
        QName nodeType = pathArg.getNodeType();
        String elementNamespace = nodeType.getNamespace().toString();
        if (data.getElementsByTagNameNS(elementNamespace, nodeType.getLocalName()).getLength() != 0) {
            return;
        }
        Element childElement = data.getOwnerDocument().createElementNS(elementNamespace, nodeType.getLocalName());
        data.appendChild(childElement);
        if (pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArg;
            NormalizedDataUtil.appendListKeyNodes(childElement, nip);
        }
        for (PathNode childrenNode : pathArgumentTree.children()) {
            NormalizedDataUtil.pathArgumentTreeToXmlStructure(childrenNode, childElement);
        }
    }

    public static void appendListKeyNodes(Element parentElement, YangInstanceIdentifier.NodeIdentifierWithPredicates listEntryId) {
        for (Map.Entry key : listEntryId.entrySet()) {
            Element keyElement = parentElement.getOwnerDocument().createElementNS(((QName)key.getKey()).getNamespace().toString(), ((QName)key.getKey()).getLocalName());
            keyElement.setTextContent(key.getValue().toString());
            parentElement.appendChild(keyElement);
        }
    }

    private static List<YangInstanceIdentifier> aggregateFields(List<YangInstanceIdentifier> fields) {
        return fields.stream().filter(field -> fields.stream().filter(fieldYiid -> !field.equals(fieldYiid)).noneMatch(fieldYiid -> fieldYiid.contains((AbstractHierarchicalIdentifier)field))).collect(Collectors.toList());
    }

    private static PathNode constructPathArgumentTree(YangInstanceIdentifier query, List<YangInstanceIdentifier> fields) {
        PathNode rootTreeNode;
        Iterator queryIterator = query.getPathArguments().iterator();
        PathNode queryTreeNode = rootTreeNode = new PathNode((YangInstanceIdentifier.PathArgument)queryIterator.next());
        while (queryIterator.hasNext()) {
            queryTreeNode = queryTreeNode.ensureChild((YangInstanceIdentifier.PathArgument)queryIterator.next());
        }
        for (YangInstanceIdentifier field : fields) {
            PathNode actualFieldTreeNode = queryTreeNode;
            for (YangInstanceIdentifier.PathArgument fieldPathArg : field.getPathArguments()) {
                actualFieldTreeNode = actualFieldTreeNode.ensureChild(fieldPathArg);
            }
        }
        return rootTreeNode;
    }

    public static NormalizationResultHolder transformDOMSourceToNormalizedNode(MountPointContext mount, DOMSource value) throws XMLStreamException, URISyntaxException, IOException, SAXException {
        NormalizationResultHolder resultHolder = new NormalizationResultHolder();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)resultHolder);
        try (XmlParserStream xmlParserStream = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (MountPointContext)new ProxyMountPointContext(mount));){
            xmlParserStream.traverse(value);
        }
        return resultHolder;
    }

    public static NormalizationResultHolder transformDOMSourceToNormalizedNode(EffectiveModelContext schemaContext, DOMSource value) throws XMLStreamException, URISyntaxException, IOException, SAXException {
        return NormalizedDataUtil.transformDOMSourceToNormalizedNode(MountPointContext.of((EffectiveModelContext)schemaContext), value);
    }

    static {
        XMLOutputFactory f = XMLOutputFactory.newFactory();
        f.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        XML_FACTORY = f;
        XML_NAMESPACE_SETTER = NamespaceSetter.forFactory(XML_FACTORY);
    }

    @FunctionalInterface
    private static interface NamespaceSetter {
        public void initializeNamespace(XMLStreamWriter var1) throws XMLStreamException;

        public static NamespaceSetter forFactory(XMLOutputFactory xmlFactory) {
            String netconfNamespace = "urn:ietf:params:xml:ns:netconf:base:1.0";
            AnyXmlNamespaceContext namespaceContext = new AnyXmlNamespaceContext(Map.of("op", "urn:ietf:params:xml:ns:netconf:base:1.0"));
            try {
                XMLStreamWriter testWriter = xmlFactory.createXMLStreamWriter(new DOMResult(XmlUtil.newDocument()));
                testWriter.setNamespaceContext(namespaceContext);
            }
            catch (UnsupportedOperationException e) {
                LOG.debug("Unable to set namespace context, falling back to setPrefix()", (Throwable)e);
                return writer -> writer.setPrefix("op", "urn:ietf:params:xml:ns:netconf:base:1.0");
            }
            catch (XMLStreamException e) {
                throw new ExceptionInInitializerError(e);
            }
            return writer -> writer.setNamespaceContext(namespaceContext);
        }
    }
}

