/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.mdsal;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@NonNullByDefault
final class PathNode
implements Mutable {
    private final YangInstanceIdentifier.PathArgument argument;
    private Map<YangInstanceIdentifier.PathArgument, PathNode> children;

    private PathNode(YangInstanceIdentifier.PathArgument argument, LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode> children) {
        this.argument = Objects.requireNonNull(argument);
        this.children = Objects.requireNonNull(children);
    }

    PathNode(YangInstanceIdentifier.PathArgument argument) {
        this.argument = Objects.requireNonNull(argument);
        this.children = Map.of();
    }

    YangInstanceIdentifier.PathArgument element() {
        return this.argument;
    }

    Collection<PathNode> children() {
        return this.children.values();
    }

    boolean isEmpty() {
        return this.children.isEmpty();
    }

    PathNode copyWith(Collection<YangInstanceIdentifier.PathArgument> childArguments) {
        LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode> copy = this.children instanceof LinkedHashMap ? new LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode>(this.children) : Maps.newLinkedHashMapWithExpectedSize((int)childArguments.size());
        for (YangInstanceIdentifier.PathArgument childArgument : childArguments) {
            PathNode.ensureChild(copy, childArgument);
        }
        return new PathNode(this.argument, copy);
    }

    PathNode ensureChild(YangInstanceIdentifier.PathArgument childArgument) {
        return PathNode.ensureChild(this.mutableChildren(), childArgument);
    }

    private static PathNode ensureChild(LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode> children, YangInstanceIdentifier.PathArgument childArgument) {
        return children.computeIfAbsent(Objects.requireNonNull(childArgument), PathNode::new);
    }

    private LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode> mutableChildren() {
        Map<YangInstanceIdentifier.PathArgument, PathNode> local = this.children;
        if (local instanceof LinkedHashMap) {
            return (LinkedHashMap)local;
        }
        LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode> ret = new LinkedHashMap<YangInstanceIdentifier.PathArgument, PathNode>(4);
        this.children = ret;
        return ret;
    }
}

