/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.mdsal;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Beta
@NonNullByDefault
public abstract sealed class DOMNotificationEvent
implements DOMEvent,
DOMNotification {
    private final ContainerNode body;
    private final Instant eventTime;

    DOMNotificationEvent(ContainerNode body, Instant eventTime) {
        this.body = Objects.requireNonNull(body);
        this.eventTime = Objects.requireNonNull(eventTime);
    }

    public final ContainerNode getBody() {
        return this.body;
    }

    public final Instant getEventInstant() {
        return this.eventTime;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(DOMNotificationEvent.class)).add("body", (Object)this.body.prettyTree()).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("type", (Object)this.getType()).add("eventTime", (Object)this.eventTime);
    }

    public static final class Rfc7950
    extends DOMNotificationEvent {
        private final SchemaNodeIdentifier.Absolute type;
        private final YangInstanceIdentifier path;

        public Rfc7950(SchemaNodeIdentifier.Absolute type, YangInstanceIdentifier path, ContainerNode body, Instant eventTime) {
            super(body, eventTime);
            this.type = Objects.requireNonNull(type);
            this.path = Objects.requireNonNull(path);
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path must not be empty");
            }
        }

        public SchemaNodeIdentifier.Absolute getType() {
            return this.type;
        }

        public YangInstanceIdentifier path() {
            return this.path;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("path", (Object)this.path);
        }
    }

    public static final class Rfc6020
    extends DOMNotificationEvent {
        public Rfc6020(ContainerNode body, Instant eventTime) {
            super(body, eventTime);
        }

        public SchemaNodeIdentifier.Absolute getType() {
            return SchemaNodeIdentifier.Absolute.of((QName)this.getBody().name().getNodeType());
        }
    }
}

