/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.capability.ExiCapability;
import org.opendaylight.netconf.api.capability.ExiSchemas;
import org.opendaylight.netconf.api.capability.SimpleCapability;
import org.opendaylight.netconf.api.capability.YangModuleCapability;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public final class CapabilityUtil {
    private static final String MODULE_PARAM = "module";
    private static final String REVISION_PARAM = "revision";
    private static final String FEATURES_PARAM = "features";
    private static final String DEVIATIONS_PARAM = "deviations";
    private static final String COMPRESSION_PARAM = "compression";
    private static final String SCHEMAS_PARAM = "schemas";

    private CapabilityUtil() {
    }

    public static @NonNull Capability parse(@NonNull String urn) {
        Objects.requireNonNull(urn);
        Preconditions.checkArgument((!urn.isEmpty() ? 1 : 0) != 0, (Object)"Urn is empty");
        String[] urnParts = urn.split("\\?");
        if (urnParts.length == 1) {
            SimpleCapability simpleCapability = SimpleCapability.forURN((String)urn);
            if (simpleCapability != null) {
                return simpleCapability;
            }
            if (urn.equals("urn:ietf:params:netconf:capability:exi:1.0")) {
                return new ExiCapability(null, null);
            }
            return new YangModuleCapability(urn, null, null, null, null);
        }
        Map<String, String> parameters = CapabilityUtil.parseParameters(urnParts[1]);
        if (urnParts[0].equals("urn:ietf:params:netconf:capability:exi:1.0")) {
            return CapabilityUtil.parseExiCapability(parameters);
        }
        return CapabilityUtil.parseYangModuleCapability(urnParts[0], parameters);
    }

    public static @NonNull List<YangModuleCapability> extractYangModuleCapabilities(@NonNull EffectiveModelContext context) {
        Objects.requireNonNull(context);
        Collection modules = context.getModules();
        ArrayList<YangModuleCapability> list = new ArrayList<YangModuleCapability>(modules.size());
        Map<QNameModule, List<String>> deviationsMap = CapabilityUtil.buildDeviationsMap(context);
        for (Module module : modules) {
            String moduleNamespace = module.getNamespace().toString();
            String moduleName = module.getName();
            String revision = module.getRevision().map(Revision::toString).orElse(null);
            QNameModule namespace = module.getQNameModule();
            List<String> features = module.getFeatures().stream().map(SchemaNode::getQName).filter(featureName -> namespace.equals((Object)featureName.getModule())).map(AbstractQName::getLocalName).toList();
            List<String> deviations = deviationsMap.get(namespace);
            list.add(new YangModuleCapability(moduleNamespace, moduleName, revision, features, deviations));
        }
        return ImmutableList.copyOf(list);
    }

    private static Map<QNameModule, List<String>> buildDeviationsMap(EffectiveModelContext context) {
        HashMap<QNameModule, List> result = new HashMap<QNameModule, List>();
        for (Module module : context.getModules()) {
            if (module.getDeviations() == null || module.getDeviations().isEmpty()) continue;
            for (Deviation deviation : module.getDeviations()) {
                QNameModule targetQname = deviation.getTargetPath().lastNodeIdentifier().getModule();
                result.computeIfAbsent(targetQname, key -> new LinkedList()).add(module.getName());
            }
        }
        return ImmutableMap.copyOf(result);
    }

    private static Capability parseYangModuleCapability(String moduleNamespace, Map<String, String> parameters) {
        String moduleName = parameters.getOrDefault(MODULE_PARAM, null);
        String revision = parameters.getOrDefault(REVISION_PARAM, null);
        List<String> features = parameters.containsKey(FEATURES_PARAM) ? Arrays.stream(parameters.get(FEATURES_PARAM).split(",")).toList() : null;
        List<String> deviations = parameters.containsKey(DEVIATIONS_PARAM) ? Arrays.stream(parameters.get(DEVIATIONS_PARAM).split(",")).toList() : null;
        return new YangModuleCapability(moduleNamespace, moduleName, revision, features, deviations);
    }

    private static Capability parseExiCapability(Map<String, String> parameters) {
        Integer compression = parameters.containsKey(COMPRESSION_PARAM) ? Integer.valueOf(Integer.parseInt(parameters.get(COMPRESSION_PARAM))) : null;
        ExiSchemas schemas = parameters.containsKey(SCHEMAS_PARAM) ? CapabilityUtil.getSchemas(parameters.get(SCHEMAS_PARAM)) : null;
        return new ExiCapability(compression, schemas);
    }

    private static ExiSchemas getSchemas(String value) {
        return switch (value) {
            case "builtin" -> ExiSchemas.BUILTIN;
            case "base:1.1" -> ExiSchemas.BASE_1_1;
            case "dynamic" -> ExiSchemas.DYNAMIC;
            default -> null;
        };
    }

    private static Map<String, String> parseParameters(String parametersString) {
        String[] parameters = parametersString.split("&");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String parameter : parameters) {
            int index = parameter.indexOf("=");
            result.put(parameter.substring(0, index), parameter.substring(index + 1));
        }
        return result;
    }
}

