/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Promise;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.codec.EOMFrameDecoder;
import org.opendaylight.netconf.codec.HelloMessageWriter;
import org.opendaylight.netconf.codec.MessageEncoder;
import org.opendaylight.netconf.codec.MessageWriter;
import org.opendaylight.netconf.nettyutil.handler.HelloXMLMessageDecoder;

public abstract class AbstractChannelInitializer<S extends NetconfSession> {
    public static final String NETCONF_SESSION_NEGOTIATOR = "negotiator";

    public void initialize(Channel ch, Promise<S> promise) {
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new EOMFrameDecoder());
        this.initializeMessageDecoder(ch);
        ch.pipeline().addLast("netconfMessageEncoder", (ChannelHandler)new MessageEncoder((MessageWriter)HelloMessageWriter.pretty()));
        this.initializeSessionNegotiator(ch, promise);
    }

    protected void initializeMessageDecoder(Channel ch) {
        ch.pipeline().addLast("netconfMessageDecoder", (ChannelHandler)new HelloXMLMessageDecoder());
    }

    protected abstract void initializeSessionNegotiator(Channel var1, Promise<S> var2);
}

