/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import io.netty.channel.Channel;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.NetconfExiSession;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.codec.MessageDecoder;
import org.opendaylight.netconf.codec.MessageWriter;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.netconf.nettyutil.handler.NetconfEXICodec;
import org.opendaylight.netconf.nettyutil.handler.exi.EXIParameters;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.UnsupportedOption;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractNetconfExiSession<S extends AbstractNetconfExiSession<S, L>, L extends NetconfSessionListener<S>>
extends AbstractNetconfSession<S, L>
implements NetconfExiSession {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfExiSession.class);

    protected AbstractNetconfExiSession(L sessionListener, Channel channel, SessionIdType sessionId) {
        super(sessionListener, channel, sessionId);
    }

    public final void startExiCommunication(NetconfMessage startExiMessage) {
        MessageDecoder exiDecoder;
        EXIParameters exiParams;
        try {
            exiParams = EXIParameters.fromXmlElement(XmlElement.fromDomDocument((Document)startExiMessage.getDocument()));
        }
        catch (UnsupportedOption e) {
            LOG.warn("Unable to parse EXI parameters from {} on session {}", new Object[]{startExiMessage, this, e});
            throw new IllegalArgumentException("Cannot parse options", e);
        }
        NetconfEXICodec exiCodec = NetconfEXICodec.forParameters(exiParams);
        MessageWriter exiWriter = exiCodec.newMessageWriter();
        try {
            exiDecoder = exiCodec.newMessageDecoder();
        }
        catch (EXIException e) {
            LOG.warn("Failed to instantiate EXI decodeer for {} on session {}", new Object[]{exiCodec, this, e});
            throw new IllegalStateException("Cannot instantiate encoder for options", e);
        }
        this.addExiHandlers(exiDecoder, exiWriter);
        LOG.debug("Session {} EXI handlers added to pipeline", (Object)this);
    }

    @NonNullByDefault
    protected abstract void addExiHandlers(MessageDecoder var1, MessageWriter var2);

    @NonNullByDefault
    protected final void replaceMessageDecoder(MessageDecoder newDecoder) {
        this.replaceChannelHandler(MessageDecoder.class, "netconfMessageDecoder", newDecoder);
    }

    @NonNullByDefault
    protected final void setMessageWriter(MessageWriter newWriter) {
        this.messageEncoder().setWriter(newWriter);
    }

    @NonNullByDefault
    protected final void setMessageWriterAfterNextMessage(MessageWriter newWriter) {
        this.messageEncoder().setNextWriter(newWriter);
    }
}

