/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.MessageDecoder;
import org.opendaylight.netconf.nettyutil.handler.ThreadLocalSAXDecoder;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class EXIMessageDecoder
extends MessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(EXIMessageDecoder.class);
    private static final SAXTransformerFactory FACTORY;
    private final DocumentBuilder documentBuilder = UntrustedXML.newDocumentBuilder();
    private final ThreadLocalSAXDecoder reader;

    EXIMessageDecoder(ThreadLocalSAXDecoder reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException, SAXException, TransformerConfigurationException {
        if (!in.isReadable()) {
            LOG.debug("No more content in incoming buffer.");
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
        }
        TransformerHandler handler = FACTORY.newTransformerHandler();
        this.reader.setContentHandler(handler);
        DOMResult domResult = new DOMResult(this.documentBuilder.newDocument());
        handler.setResult(domResult);
        try (ByteBufInputStream is = new ByteBufInputStream(in);){
            this.reader.parse(new InputSource((InputStream)is));
        }
        out.add(new NetconfMessage((Document)domResult.getNode()));
    }

    static {
        SAXTransformerFactory f = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (!f.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new TransformerFactoryConfigurationError(String.format("Factory %s is not a SAXTransformerFactory", f));
        }
        FACTORY = f;
    }
}

