/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.MessageWriter;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXEncoder;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXFactory;
import org.xml.sax.ContentHandler;

final class EXIMessageWriter
extends MessageWriter {
    private final SAXFactory factory;

    EXIMessageWriter(SAXFactory factory) {
        super(false);
        this.factory = Objects.requireNonNull(factory);
    }

    protected void writeTo(NetconfMessage message, OutputStream out) throws IOException, TransformerException {
        SAXEncoder encoder;
        try {
            encoder = this.factory.createEXIWriter();
            encoder.setOutputStream(out);
        }
        catch (EXIException e) {
            throw new IOException(e);
        }
        this.threadLocalTransformer().transform(new DOMSource(message.getDocument()), new SAXResult((ContentHandler)encoder));
    }
}

