/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.codec.MessageDecoder;
import org.opendaylight.odlparent.logging.markers.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class HelloXMLMessageDecoder
extends MessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(HelloXMLMessageDecoder.class);
    private static final List<byte[]> POSSIBLE_ENDS = List.of(new byte[]{93, 10}, new byte[]{93, 13, 10});
    private static final List<byte[]> POSSIBLE_STARTS = List.of(new byte[]{91}, new byte[]{13, 10, 91}, new byte[]{10, 91});
    private final List<NetconfMessage> nonHelloMessages = new ArrayList<NetconfMessage>();
    private boolean helloReceived = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException, SAXException {
        block9: {
            if (in.readableBytes() == 0) {
                LOG.debug("No more content in incoming buffer.");
                return;
            }
            in.markReaderIndex();
            try {
                Document doc;
                NetconfMessage message;
                int endOfAuthHeader;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
                }
                byte[] bytes = new byte[in.readableBytes()];
                in.readBytes(bytes);
                HelloXMLMessageDecoder.logMessage(bytes);
                String additionalHeader = null;
                if (HelloXMLMessageDecoder.startsWithAdditionalHeader(bytes) && (endOfAuthHeader = HelloXMLMessageDecoder.getAdditionalHeaderEndIndex(bytes)) > -1) {
                    byte[] additionalHeaderBytes = Arrays.copyOfRange(bytes, 0, endOfAuthHeader);
                    additionalHeader = HelloXMLMessageDecoder.additionalHeaderToString(additionalHeaderBytes);
                    bytes = Arrays.copyOfRange(bytes, endOfAuthHeader, bytes.length);
                }
                if ((message = HelloXMLMessageDecoder.getNetconfMessage(additionalHeader, doc = XmlUtil.readXmlToDocument((InputStream)new ByteArrayInputStream(bytes)))) instanceof HelloMessage) {
                    if (this.helloReceived) {
                        throw new IllegalStateException("Multiple hello messages received, unexpected hello: " + String.valueOf(message));
                    }
                    out.add(message);
                    this.helloReceived = true;
                    break block9;
                }
                if (this.helloReceived) {
                    LOG.debug("Netconf message received during negotiation, caching {}", (Object)message);
                    this.nonHelloMessages.add(message);
                    break block9;
                }
                throw new IllegalStateException("Hello message not received, instead received: " + String.valueOf(message));
            }
            finally {
                in.discardReadBytes();
            }
        }
    }

    private static NetconfMessage getNetconfMessage(String additionalHeader, Document doc) {
        NetconfMessage msg = new NetconfMessage(doc);
        if (HelloMessage.isHelloMessage((NetconfMessage)msg)) {
            if (additionalHeader != null) {
                return new HelloMessage(doc, NetconfHelloMessageAdditionalHeader.fromString((String)additionalHeader));
            }
            return new HelloMessage(doc);
        }
        return msg;
    }

    private static int getAdditionalHeaderEndIndex(byte[] bytes) {
        for (byte[] possibleEnd : POSSIBLE_ENDS) {
            int idx = HelloXMLMessageDecoder.findByteSequence(bytes, possibleEnd);
            if (idx == -1) continue;
            return idx + possibleEnd.length;
        }
        return -1;
    }

    private static int findByteSequence(byte[] bytes, byte[] sequence) {
        if (bytes.length < sequence.length) {
            throw new IllegalArgumentException("Sequence to be found is longer than the given byte array.");
        }
        if (bytes.length == sequence.length) {
            if (Arrays.equals(bytes, sequence)) {
                return 0;
            }
            return -1;
        }
        int index = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == sequence[index]) {
                if (++index != sequence.length) continue;
                return i - index + 1;
            }
            index = 0;
        }
        return -1;
    }

    private static void logMessage(byte[] bytes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Markers.confidential(), "Parsing message \n{}", (Object)StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString());
        }
    }

    private static boolean startsWithAdditionalHeader(byte[] bytes) {
        for (byte[] possibleStart : POSSIBLE_STARTS) {
            int index = 0;
            for (byte b : possibleStart) {
                if (bytes[index++] != b) break;
                if (index != possibleStart.length) continue;
                return true;
            }
        }
        return false;
    }

    private static String additionalHeaderToString(byte[] bytes) {
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public Iterable<NetconfMessage> getPostHelloNetconfMessages() {
        return this.nonHelloMessages;
    }
}

