/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.EOFException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.MessageEncoder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetconfSession<S extends NetconfSession, L extends NetconfSessionListener<S>>
extends SimpleChannelInboundHandler<Object>
implements NetconfSession {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfSession.class);
    protected final @NonNull Channel channel;
    private final @NonNull SessionIdType sessionId;
    private final @NonNull L sessionListener;
    private boolean up;

    protected AbstractNetconfSession(L sessionListener, Channel channel, SessionIdType sessionId) {
        this.sessionListener = (NetconfSessionListener)Objects.requireNonNull(sessionListener);
        this.channel = Objects.requireNonNull(channel);
        this.sessionId = Objects.requireNonNull(sessionId);
        LOG.debug("Session {} created", (Object)sessionId);
    }

    public final SessionIdType sessionId() {
        return this.sessionId;
    }

    protected abstract S thisInstance();

    public void close() {
        this.up = false;
        this.channel.close();
        this.sessionListener.onSessionTerminated(this.thisInstance(), new NetconfTerminationReason("Session closed"));
    }

    protected void handleMessage(NetconfMessage netconfMessage) {
        LOG.debug("handling incoming message");
        this.sessionListener.onMessage(this.thisInstance(), netconfMessage);
    }

    protected void handleError(Exception failure) {
        LOG.debug("handling incoming error");
        this.sessionListener.onError(this.thisInstance(), failure);
    }

    public ChannelFuture sendMessage(NetconfMessage netconfMessage) {
        ChannelPromise promise = this.channel.newPromise();
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush((Object)netconfMessage, promise));
        return promise;
    }

    protected void endOfInput() {
        LOG.debug("Session {} end of input detected while session was in state {}", (Object)this, (Object)(this.up ? "up" : "initialized"));
        if (this.up) {
            this.sessionListener.onSessionDown(this.thisInstance(), (Exception)new EOFException("End of input"));
        }
    }

    protected void sessionUp() {
        LOG.debug("Session {} up", (Object)this);
        this.sessionListener.onSessionUp(this.thisInstance());
        this.up = true;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)((Object)this))).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("sessionId", (Object)this.sessionId.getValue()).add("channel", (Object)this.channel);
    }

    protected final <T extends ChannelHandler> void replaceChannelHandler(Class<T> type, String name, T handler) {
        this.channel.pipeline().replace(type, name, handler);
    }

    protected final @NonNull MessageEncoder messageEncoder() {
        return (MessageEncoder)Verify.verifyNotNull((Object)((MessageEncoder)this.channel.pipeline().get(MessageEncoder.class)), (String)"No MessageEncoder present", (Object[])new Object[0]);
    }

    public final boolean isUp() {
        return this.up;
    }

    public final void channelInactive(ChannelHandlerContext ctx) {
        LOG.debug("Channel {} inactive.", (Object)ctx.channel());
        this.endOfInput();
        try {
            super.channelInactive(ctx);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to delegate channel inactive event on channel " + String.valueOf(ctx.channel()), e);
        }
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) {
        LOG.debug("Message was received: {}", msg);
        Object object = msg;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NetconfMessage.class, Exception.class}, (Object)object2, n)) {
            case 0: {
                NetconfMessage message = (NetconfMessage)object2;
                this.handleMessage(message);
                break;
            }
            case 1: {
                Exception failure = (Exception)object2;
                this.handleError(failure);
                break;
            }
            default: {
                LOG.warn("Ignoring unexpected message {}", msg);
            }
        }
    }

    public final void handlerAdded(ChannelHandlerContext ctx) {
        this.sessionUp();
    }
}

