/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import java.io.IOException;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXDecoder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ThreadLocalSAXDecoder
extends SAXDecoder {
    private static final int INITIAL_SIZE = 4096;
    private static final int CACHE_MAX_SIZE = 32768;
    private static final ThreadLocal<char[]> CBUFFER_CACHE = ThreadLocal.withInitial(() -> new char[4096]);

    ThreadLocalSAXDecoder(EXIFactory noOptionsFactory) throws EXIException {
        super(noOptionsFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source) throws IOException, SAXException {
        this.cbuffer = CBUFFER_CACHE.get();
        int startSize = this.cbuffer.length;
        try {
            super.parse(source);
        }
        finally {
            char[] toCache = this.cbuffer;
            this.cbuffer = null;
            if (toCache.length > 32768 && startSize < 32768) {
                toCache = new char[32768];
            }
            CBUFFER_CACHE.set(toCache);
        }
    }
}

