/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.exi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.nettyutil.handler.exi.EXISchema;
import org.opendaylight.netconf.shaded.exificient.core.CodingMode;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.EncodingOptions;
import org.opendaylight.netconf.shaded.exificient.core.FidelityOptions;
import org.opendaylight.netconf.shaded.exificient.core.SchemaIdResolver;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.UnsupportedOption;
import org.opendaylight.netconf.shaded.exificient.core.helpers.DefaultEXIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EXIParameters {
    private static final Logger LOG = LoggerFactory.getLogger(EXIParameters.class);
    static final String EXI_PARAMETER_ALIGNMENT = "alignment";
    private static final String EXI_PARAMETER_BYTE_ALIGNED = "byte-aligned";
    private static final String EXI_PARAMETER_BIT_PACKED = "bit-packed";
    private static final String EXI_PARAMETER_COMPRESSED = "compressed";
    private static final String EXI_PARAMETER_PRE_COMPRESSION = "pre-compression";
    static final String EXI_PARAMETER_FIDELITY = "fidelity";
    private static final String EXI_FIDELITY_DTD = "dtd";
    private static final String EXI_FIDELITY_LEXICAL_VALUES = "lexical-values";
    private static final String EXI_FIDELITY_COMMENTS = "comments";
    private static final String EXI_FIDELITY_PIS = "pis";
    private static final String EXI_FIDELITY_PREFIXES = "prefixes";
    static final String EXI_PARAMETER_SCHEMAS = "schemas";
    private static final SchemaIdResolver SCHEMA_RESOLVER = schemaId -> {
        if (schemaId == null) {
            return null;
        }
        if (schemaId.isEmpty()) {
            return EXISchema.BUILTIN.getGrammar();
        }
        if (schemaId.equals(EXISchema.BASE_1_1.getOption())) {
            return EXISchema.BASE_1_1.getGrammar();
        }
        throw new EXIException("Cannot resolve schema " + schemaId);
    };
    private static final EncodingOptions ENCODING_OPTIONS;
    private final FidelityOptions fidelityOptions;
    private final CodingMode codingMode;
    private final EXISchema schema;

    public EXIParameters(CodingMode codingMode, FidelityOptions fidelityOptions) {
        this(codingMode, fidelityOptions, EXISchema.NONE);
    }

    public EXIParameters(CodingMode codingMode, FidelityOptions fidelityOptions, EXISchema schema) {
        this.fidelityOptions = Objects.requireNonNull(fidelityOptions);
        this.codingMode = Objects.requireNonNull(codingMode);
        this.schema = Objects.requireNonNull(schema);
    }

    @VisibleForTesting
    public static EXIParameters empty() {
        return new EXIParameters(CodingMode.BIT_PACKED, FidelityOptions.createDefault());
    }

    public static EXIParameters fromXmlElement(XmlElement root) throws UnsupportedOption {
        EXISchema schema;
        NodeList schemaElements;
        CodingMode coding;
        NodeList alignmentElements = root.getElementsByTagName(EXI_PARAMETER_ALIGNMENT);
        if (alignmentElements.getLength() > 0) {
            String alignmentTextContent;
            Element alignmentElement = (Element)alignmentElements.item(0);
            switch (alignmentTextContent = alignmentElement.getTextContent().trim()) {
                case "byte-aligned": {
                    coding = CodingMode.BYTE_PACKED;
                    break;
                }
                case "compressed": {
                    coding = CodingMode.COMPRESSION;
                    break;
                }
                case "pre-compression": {
                    coding = CodingMode.PRE_COMPRESSION;
                    break;
                }
                case "bit-packed": {
                    coding = CodingMode.BIT_PACKED;
                    break;
                }
                default: {
                    LOG.warn("Unexpected value in alignmentTextContent: {} , using default value", (Object)alignmentTextContent);
                    coding = CodingMode.BIT_PACKED;
                    break;
                }
            }
        } else {
            coding = CodingMode.BIT_PACKED;
        }
        FidelityOptions fidelity = FidelityOptions.createDefault();
        NodeList fidelityElements = root.getElementsByTagName(EXI_PARAMETER_FIDELITY);
        if (fidelityElements.getLength() > 0) {
            Element fidelityElement = (Element)fidelityElements.item(0);
            fidelity.setFidelity("PRESERVE_DTDS", fidelityElement.getElementsByTagName(EXI_FIDELITY_DTD).getLength() > 0);
            fidelity.setFidelity("PRESERVE_LEXICAL_VALUES", fidelityElement.getElementsByTagName(EXI_FIDELITY_LEXICAL_VALUES).getLength() > 0);
            fidelity.setFidelity("PRESERVE_COMMENTS", fidelityElement.getElementsByTagName(EXI_FIDELITY_COMMENTS).getLength() > 0);
            fidelity.setFidelity("PRESERVE_PIS", fidelityElement.getElementsByTagName(EXI_FIDELITY_PIS).getLength() > 0);
            fidelity.setFidelity("PRESERVE_PREFIXES", fidelityElement.getElementsByTagName(EXI_FIDELITY_PREFIXES).getLength() > 0);
        }
        if ((schemaElements = root.getElementsByTagName(EXI_PARAMETER_SCHEMAS)).getLength() > 0) {
            Element schemaElement = (Element)schemaElements.item(0);
            String schemaName = schemaElement.getTextContent().trim();
            schema = EXISchema.forOption(schemaName);
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Unsupported schema name %s", (Object)schemaName);
        } else {
            schema = EXISchema.NONE;
        }
        return new EXIParameters(coding, fidelity, schema);
    }

    public EXIFactory getFactory() {
        EXIFactory factory = DefaultEXIFactory.newInstance();
        factory.setCodingMode(this.codingMode);
        factory.setEncodingOptions(ENCODING_OPTIONS);
        factory.setFidelityOptions(this.fidelityOptions);
        factory.setGrammars(this.schema.getGrammar());
        factory.setSchemaIdResolver(SCHEMA_RESOLVER);
        return factory;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fidelityOptions, this.codingMode, this.schema});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EXIParameters)) {
            return false;
        }
        EXIParameters other = (EXIParameters)obj;
        return this.codingMode == other.codingMode && this.schema == other.schema && this.fidelityOptions.equals((Object)other.fidelityOptions);
    }

    String getAlignment() {
        switch (this.codingMode) {
            case BIT_PACKED: {
                return EXI_PARAMETER_BIT_PACKED;
            }
            case BYTE_PACKED: {
                return EXI_PARAMETER_BYTE_ALIGNED;
            }
            case COMPRESSION: {
                return EXI_PARAMETER_COMPRESSED;
            }
            case PRE_COMPRESSION: {
                return EXI_PARAMETER_PRE_COMPRESSION;
            }
        }
        throw new IllegalStateException("Unhandled coding mode " + String.valueOf(this.codingMode));
    }

    private String fidelityString(String feature, String string) {
        return this.fidelityOptions.isFidelityEnabled(feature) ? string : null;
    }

    String getPreserveComments() {
        return this.fidelityString("PRESERVE_COMMENTS", EXI_FIDELITY_COMMENTS);
    }

    String getPreserveDTD() {
        return this.fidelityString("PRESERVE_DTDS", EXI_FIDELITY_DTD);
    }

    String getPreserveLexicalValues() {
        return this.fidelityString("PRESERVE_LEXICAL_VALUES", EXI_FIDELITY_LEXICAL_VALUES);
    }

    String getPreservePIs() {
        return this.fidelityString("PRESERVE_PIS", EXI_FIDELITY_PIS);
    }

    String getPreservePrefixes() {
        return this.fidelityString("PRESERVE_PREFIXES", EXI_FIDELITY_PREFIXES);
    }

    String getSchema() {
        return this.schema == EXISchema.NONE ? null : this.schema.name();
    }

    static {
        EncodingOptions opts = EncodingOptions.createDefault();
        try {
            opts.setOption("KEEP_ENTITY_REFERENCES_UNRESOLVED");
            opts.setOption("INCLUDE_OPTIONS");
            opts.setOption("INCLUDE_COOKIE");
        }
        catch (UnsupportedOption e) {
            throw new ExceptionInInitializerError(e);
        }
        ENCODING_OPTIONS = opts;
    }
}

