/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.exi;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.netconf.api.messages.RpcMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.nettyutil.handler.exi.EXIParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfStartExiMessageProvider {
    @VisibleForTesting
    public static final String START_EXI = "start-exi";

    private NetconfStartExiMessageProvider() {
    }

    public static RpcMessage create(EXIParameters exiOptions, String messageId) {
        Document doc = XmlUtil.newDocument();
        Element startExiElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", START_EXI);
        NetconfStartExiMessageProvider.addAlignment(exiOptions, doc, startExiElement);
        NetconfStartExiMessageProvider.addFidelity(exiOptions, doc, startExiElement);
        NetconfStartExiMessageProvider.addSchema(exiOptions, doc, startExiElement);
        doc.appendChild(startExiElement);
        return RpcMessage.ofOperation((String)messageId, (Document)doc);
    }

    private static void addAlignment(EXIParameters exiOptions, Document doc, Element startExiElement) {
        Element alignmentElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", "alignment");
        alignmentElement.setTextContent(exiOptions.getAlignment());
        startExiElement.appendChild(alignmentElement);
    }

    private static void addFidelity(EXIParameters exiOptions, Document doc, Element startExiElement) {
        ArrayList<Element> fidelityElements = new ArrayList<Element>(5);
        NetconfStartExiMessageProvider.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveComments());
        NetconfStartExiMessageProvider.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveDTD());
        NetconfStartExiMessageProvider.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveLexicalValues());
        NetconfStartExiMessageProvider.createFidelityElement(doc, fidelityElements, exiOptions.getPreservePIs());
        NetconfStartExiMessageProvider.createFidelityElement(doc, fidelityElements, exiOptions.getPreservePrefixes());
        if (!fidelityElements.isEmpty()) {
            Element fidelityElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", "fidelity");
            for (Element element : fidelityElements) {
                fidelityElement.appendChild(element);
            }
            startExiElement.appendChild(fidelityElement);
        }
    }

    private static void addSchema(EXIParameters exiOptions, Document doc, Element startExiElement) {
        String schema = exiOptions.getSchema();
        if (schema != null) {
            Element child = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", "schemas");
            child.setTextContent(schema);
            startExiElement.appendChild(child);
        }
    }

    private static void createFidelityElement(Document doc, List<Element> elements, String fidelity) {
        if (fidelity != null) {
            elements.add(doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", fidelity));
        }
    }
}

