/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.databind.DatabindContext;
import org.opendaylight.netconf.databind.DatabindProvider;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.monitoring.YangModuleCapability;
import org.opendaylight.netconf.server.mdsal.NetconfServerStrategy;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurrentSchemaContext
implements DatabindProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentSchemaContext.class);
    private final AtomicReference<NetconfServerStrategy> currentStrategy = new AtomicReference();
    private final Set<CapabilityListener> listeners = Collections.synchronizedSet(new HashSet());
    private final DOMSchemaService.YangTextSourceExtension yangTextSourceExtension;
    private final Registration registration;

    public CurrentSchemaContext(DOMSchemaService schemaService) {
        this.yangTextSourceExtension = (DOMSchemaService.YangTextSourceExtension)schemaService.extension(DOMSchemaService.YangTextSourceExtension.class);
        this.registration = schemaService.registerSchemaContextListener(this::onModelContextUpdated);
    }

    @NonNull NetconfServerStrategy currentStrategy() {
        return (NetconfServerStrategy)Verify.verifyNotNull((Object)this.currentStrategy.get(), (String)"Current context not received", (Object[])new Object[0]);
    }

    public DatabindContext currentDatabind() {
        return this.currentStrategy().databind();
    }

    private void onModelContextUpdated(EffectiveModelContext modelContext) {
        DatabindContext newDatabind = DatabindContext.ofModel((EffectiveModelContext)modelContext);
        NetconfServerStrategy newStrategy = new NetconfServerStrategy(newDatabind, this.createCapabilities(newDatabind.modelContext()));
        this.currentStrategy.set(newStrategy);
        for (CapabilityListener listener : this.listeners) {
            listener.onCapabilitiesChanged(newStrategy.capabilities(), Set.of());
        }
    }

    @NonNullByDefault
    private ImmutableSet<Capability> createCapabilities(EffectiveModelContext modelContext) {
        HashSet capabilities = new HashSet();
        for (Module module : modelContext.getModules()) {
            CurrentSchemaContext.moduleToCapability((ModuleLike)module, this.yangTextSourceExtension).ifPresent(capabilities::add);
            for (Submodule submodule : module.getSubmodules()) {
                CurrentSchemaContext.moduleToCapability((ModuleLike)submodule, this.yangTextSourceExtension).ifPresent(capabilities::add);
            }
        }
        return (ImmutableSet)capabilities.stream().sorted(Comparator.comparing(Capability::getCapabilityUri)).collect(ImmutableSet.toImmutableSet());
    }

    private static Optional<YangModuleCapability> moduleToCapability(ModuleLike module, DOMSchemaService.YangTextSourceExtension yangTextSourceExtension) {
        String source;
        String moduleNamespace = module.getNamespace().toString();
        String moduleName = module.getName();
        String revision = module.getRevision().map(Revision::toString).orElse(null);
        SourceIdentifier moduleSourceIdentifier = new SourceIdentifier(moduleName, revision);
        try {
            source = ((YangTextSource)yangTextSourceExtension.getYangTexttSource(moduleSourceIdentifier).get()).read();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.warn("Ignoring source for module {}. Unable to read content", (Object)moduleSourceIdentifier, (Object)e);
            source = null;
        }
        if (source != null) {
            return Optional.of(new YangModuleCapability(moduleNamespace, moduleName, revision, source));
        }
        LOG.warn("Missing source for module {}. This module will not be available from netconf server", (Object)moduleSourceIdentifier);
        return Optional.empty();
    }

    @Override
    public void close() {
        this.registration.close();
        this.listeners.clear();
        this.currentStrategy.set(null);
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        listener.onCapabilitiesChanged(this.currentStrategy().capabilities(), Set.of());
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

