/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal;

import com.google.common.collect.ImmutableSet;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.databind.DatabindProvider;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.mdsal.TransactionProvider;
import org.opendaylight.netconf.server.mdsal.operations.Commit;
import org.opendaylight.netconf.server.mdsal.operations.CopyConfig;
import org.opendaylight.netconf.server.mdsal.operations.DiscardChanges;
import org.opendaylight.netconf.server.mdsal.operations.EditConfig;
import org.opendaylight.netconf.server.mdsal.operations.Get;
import org.opendaylight.netconf.server.mdsal.operations.GetConfig;
import org.opendaylight.netconf.server.mdsal.operations.Lock;
import org.opendaylight.netconf.server.mdsal.operations.RuntimeRpc;
import org.opendaylight.netconf.server.mdsal.operations.Unlock;
import org.opendaylight.netconf.server.mdsal.operations.Validate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;

final class MdsalNetconfOperationService
implements NetconfOperationService {
    private final ImmutableSet<NetconfOperation> operations;
    private final TransactionProvider transactionProvider;

    MdsalNetconfOperationService(DatabindProvider databindProvider, SessionIdType sessionId, DOMDataBroker dataBroker, DOMRpcService rpcService) {
        this.transactionProvider = new TransactionProvider(dataBroker, sessionId);
        this.operations = ImmutableSet.of((Object)((Object)new Commit(sessionId, this.transactionProvider)), (Object)((Object)new DiscardChanges(sessionId, this.transactionProvider)), (Object)((Object)new EditConfig(sessionId, databindProvider, this.transactionProvider)), (Object)((Object)new CopyConfig(sessionId, databindProvider, this.transactionProvider)), (Object)((Object)new Get(sessionId, databindProvider, this.transactionProvider)), (Object)((Object)new GetConfig(sessionId, databindProvider, this.transactionProvider)), (Object[])new NetconfOperation[]{new Lock(sessionId), new Unlock(sessionId), new RuntimeRpc(sessionId, databindProvider, rpcService), new Validate(sessionId, this.transactionProvider)});
    }

    public ImmutableSet<NetconfOperation> getNetconfOperations() {
        return this.operations;
    }

    public void close() {
    }
}

